/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing;

import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.parser.ParseException;
import gama.dependencies.kabeja.parser.Parser;
import gama.dependencies.kabeja.processing.PostProcessor;
import gama.dependencies.kabeja.processing.ProcessPipeline;
import gama.dependencies.kabeja.processing.ProcessorException;
import gama.dependencies.kabeja.processing.event.ProcessingListener;
import gama.dependencies.kabeja.xml.SAXFilter;
import gama.dependencies.kabeja.xml.SAXGenerator;
import gama.dependencies.kabeja.xml.SAXSerializer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessingManager {
    private final Map<String, SAXFilter> saxfilters = new HashMap<String, SAXFilter>();
    private final Map<String, SAXSerializer> saxserializers = new HashMap<String, SAXSerializer>();
    private final Map<String, PostProcessor> postprocessors = new HashMap<String, PostProcessor>();
    private final Map<String, ProcessPipeline> pipelines = new HashMap<String, ProcessPipeline>();
    private final Map<String, SAXGenerator> saxgenerators = new HashMap<String, SAXGenerator>();
    private final List<Parser> parsers = new ArrayList<Parser>();

    public void addSAXFilter(SAXFilter sAXFilter, String string) {
        this.saxfilters.put(string, sAXFilter);
    }

    public SAXFilter getSAXFilter(String string) {
        return this.saxfilters.get(string);
    }

    public Map getSAXFilters() {
        return this.saxfilters;
    }

    public void addSAXSerializer(SAXSerializer sAXSerializer, String string) {
        this.saxserializers.put(string, sAXSerializer);
    }

    public SAXSerializer getSAXSerializer(String string) {
        return this.saxserializers.get(string);
    }

    public Map getSAXSerializers() {
        return this.saxserializers;
    }

    public void addPostProcessor(PostProcessor postProcessor, String string) {
        this.postprocessors.put(string, postProcessor);
    }

    public void addParser(Parser parser) {
        this.parsers.add(parser);
    }

    public List getParsers() {
        return this.parsers;
    }

    protected Parser getParser(String string) {
        for (Parser parser : this.parsers) {
            if (!parser.supportedExtension(string)) continue;
            return parser;
        }
        return null;
    }

    public PostProcessor getPostProcessor(String string) {
        return this.postprocessors.get(string);
    }

    public Map getPostProcessors() {
        return this.postprocessors;
    }

    public void addProcessPipeline(ProcessPipeline processPipeline) {
        processPipeline.setProcessorManager(this);
        this.pipelines.put(processPipeline.getName(), processPipeline);
    }

    public ProcessPipeline getProcessPipeline(String string) {
        return this.pipelines.get(string);
    }

    public Map getProcessPipelines() {
        return this.pipelines;
    }

    public void process(InputStream inputStream, String string, Map map, String string2, OutputStream outputStream) throws ProcessorException {
        Parser parser = this.getParser(string);
        if (parser != null) {
            try {
                parser.parse(inputStream, null);
                DXFDocument dXFDocument = parser.getDocument();
                this.process(dXFDocument, map, string2, outputStream);
            }
            catch (ParseException parseException) {
                throw new ProcessorException(parseException);
            }
        }
    }

    public void process(DXFDocument dXFDocument, Map map, String string, OutputStream outputStream) throws ProcessorException {
        if (!this.pipelines.containsKey(string)) {
            throw new ProcessorException("No pipeline found for name:" + string);
        }
        ProcessPipeline processPipeline = this.pipelines.get(string);
        processPipeline.prepare();
        processPipeline.process(dXFDocument, map, outputStream);
    }

    public void process(DXFDocument dXFDocument, Map map, String string, String string2) throws ProcessorException {
        if (!this.pipelines.containsKey(string)) {
            throw new ProcessorException("No pipeline found for name:" + string);
        }
        try {
            ProcessPipeline processPipeline = this.pipelines.get(string);
            String string3 = processPipeline.getSAXSerializer().getSuffix();
            String string4 = string2.substring(0, string2.lastIndexOf(46) + 1) + string3;
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            this.process(dXFDocument, map, string, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProcessorException(fileNotFoundException);
        }
    }

    public void addSAXGenerator(SAXGenerator sAXGenerator, String string) {
        this.saxgenerators.put(string, sAXGenerator);
    }

    public SAXGenerator getSAXGenerator(String string) {
        return this.saxgenerators.get(string);
    }

    public Map getSAXGenerators() {
        return this.saxgenerators;
    }

    public void addProcessingListener(ProcessingListener processingListener) {
    }

    public void removeProcessingListener(ProcessingListener processingListener) {
    }
}

