/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.RelationMember;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Relation
extends Entity
implements Comparable<Relation> {
    private List<RelationMember> members;

    public Relation(CommonEntityData commonEntityData) {
        super(commonEntityData);
        this.members = new ArrayList<RelationMember>();
    }

    public Relation(CommonEntityData commonEntityData, List<RelationMember> list) {
        super(commonEntityData);
        this.members = new ArrayList<RelationMember>(list);
    }

    private Relation(Relation relation) {
        super(relation);
        this.members = new ArrayList<RelationMember>(relation.members);
    }

    public Relation(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        super(storeReader, storeClassRegister);
        int n = storeReader.readInteger();
        this.members = new ArrayList<RelationMember>();
        int n2 = 0;
        while (n2 < n) {
            this.members.add(new RelationMember(storeReader, storeClassRegister));
            ++n2;
        }
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        super.store(storeWriter, storeClassRegister);
        storeWriter.writeInteger(this.members.size());
        for (RelationMember relationMember : this.members) {
            relationMember.store(storeWriter, storeClassRegister);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.Relation;
    }

    public boolean equals(Object object) {
        if (object instanceof Relation) {
            return this.compareTo((Relation)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    protected int compareMemberList(Collection<RelationMember> collection) {
        if (this.members.size() != collection.size()) {
            return this.members.size() - collection.size();
        }
        Iterator<RelationMember> iterator = this.members.iterator();
        Iterator<RelationMember> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next().compareTo(iterator2.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int compareTo(Relation relation) {
        int n;
        if (this.getId() < relation.getId()) {
            return -1;
        }
        if (this.getId() > relation.getId()) {
            return 1;
        }
        if (this.getVersion() < relation.getVersion()) {
            return -1;
        }
        if (this.getVersion() > relation.getVersion()) {
            return 1;
        }
        if (this.getTimestamp() == null && relation.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && relation.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && relation.getTimestamp() != null && (n = this.getTimestamp().compareTo(relation.getTimestamp())) != 0) {
            return n;
        }
        int n2 = this.compareMemberList(relation.members);
        if (n2 != 0) {
            return n2;
        }
        return this.compareTags(relation.getTags());
    }

    @Override
    public void makeReadOnly() {
        if (!this.isReadOnly()) {
            this.members = Collections.unmodifiableList(this.members);
        }
        super.makeReadOnly();
    }

    @Override
    public Relation getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Relation(this);
        }
        return this;
    }

    public List<RelationMember> getMembers() {
        return this.members;
    }

    public String toString() {
        String string = null;
        Collection<Tag> collection = this.getTags();
        for (Tag tag : collection) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("type")) continue;
            string = tag.getValue();
            break;
        }
        if (string != null) {
            return "Relation(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", type='" + string + "')";
        }
        return "Relation(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

