/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing;

import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.processing.AbstractPostProcessor;
import gama.dependencies.kabeja.processing.ProcessorException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class LayerFilter
extends AbstractPostProcessor {
    public static final String PROPERTY_REMOVE_LAYERS = "layers.remove";
    public static final String PROPERTY_MERGE_LAYERS = "layers.merge";
    public static final String MERGED_LAYER_NAME = "ALL";
    protected boolean merge = false;
    protected Set<String> removableLayers = new HashSet<String>();

    @Override
    public void setProperties(Map map) {
        super.setProperties(map);
        if (map.containsKey(PROPERTY_MERGE_LAYERS)) {
            this.merge = Boolean.parseBoolean((String)map.get(PROPERTY_MERGE_LAYERS));
        }
        if (map.containsKey(PROPERTY_REMOVE_LAYERS)) {
            this.removableLayers.clear();
            StringTokenizer stringTokenizer = new StringTokenizer((String)map.get(PROPERTY_REMOVE_LAYERS), "|");
            while (stringTokenizer.hasMoreTokens()) {
                this.removableLayers.add(stringTokenizer.nextToken());
            }
        }
    }

    @Override
    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        DXFLayer dXFLayer = null;
        if (this.merge) {
            if (dXFDocument.containsDXFLayer(MERGED_LAYER_NAME)) {
                dXFLayer = dXFDocument.getDXFLayer(MERGED_LAYER_NAME);
            } else {
                dXFLayer = new DXFLayer();
                dXFLayer.setName(MERGED_LAYER_NAME);
                dXFDocument.addDXFLayer(dXFLayer);
            }
        }
        Iterator iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer2 = (DXFLayer)iterator.next();
            if (this.removableLayers.contains(dXFLayer2.getName())) {
                iterator.remove();
                continue;
            }
            if (!this.merge || dXFLayer2 == dXFLayer) continue;
            Iterator<String> iterator2 = dXFLayer2.getDXFEntityTypeIterator();
            while (iterator2.hasNext()) {
                String string = iterator2.next();
                Iterator<DXFEntity> iterator3 = dXFLayer2.getDXFEntities(string).iterator();
                while (iterator3.hasNext()) {
                    DXFEntity dXFEntity = iterator3.next();
                    dXFEntity.setLayerName(MERGED_LAYER_NAME);
                    dXFDocument.addDXFEntity(dXFEntity);
                    iterator3.remove();
                }
            }
            iterator.remove();
        }
    }
}

