/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.helpers.Point;

public class HatchLineFamily {
    private double rotationAngle;
    private double baseX;
    private double baseY;
    private double offsetX;
    private double offsetY;
    private double length = 0.0;
    private double[] pattern = new double[0];

    public double getBaseX() {
        return this.baseX;
    }

    public void setBaseX(double d) {
        this.baseX = d;
    }

    public double getBaseY() {
        return this.baseY;
    }

    public void setBaseY(double d) {
        this.baseY = d;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double d) {
        this.offsetX = d;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double d) {
        this.offsetY = d;
    }

    public double[] getPattern() {
        return this.pattern;
    }

    public void setPattern(double[] dArray) {
        if (dArray != null) {
            this.pattern = dArray;
        }
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getLength() {
        if (this.length <= 0.0) {
            int n = 0;
            while (n < this.pattern.length) {
                this.length += Math.abs(this.pattern[n]);
                ++n;
            }
        }
        return this.length;
    }

    public double getPatternWidth() {
        return this.getLength() * Math.cos(this.rotationAngle);
    }

    public double getPatternHeight() {
        return this.getLength() * Math.sin(this.rotationAngle);
    }

    public Point getBasePoint() {
        return this.transform(this.baseX, this.baseY);
    }

    public Point getOffsetPoint() {
        return this.transform(this.offsetX, this.offsetY);
    }

    protected Point transform(double d, double d2) {
        Point point = new Point();
        point.setX(Math.cos(this.rotationAngle) * d + Math.sin(this.rotationAngle) * d2);
        point.setY(Math.cos(this.rotationAngle) * d2 - Math.sin(this.rotationAngle) * d);
        return point;
    }

    public Point getMinimalBasePoint() {
        Point point = new Point();
        Point point2 = this.getBasePoint();
        Point point3 = this.getOffsetPoint();
        point.setX(point2.getX() % point3.getX());
        point.setY(point2.getY() % point3.getY());
        return point;
    }
}

