/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import com.google.protobuf.ByteString;
import gama.dependencies.osmosis.FileBlock;
import gama.dependencies.osmosis.FileBlockReference;
import gama.dependencies.osmosis.FileFormatException;
import gama.dependencies.osmosis.Fileformat;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileBlockHead
extends FileBlockReference {
    protected FileBlockHead(String string, ByteString byteString) {
        super(string, byteString);
    }

    static FileBlockHead readHead(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n > 65536) {
            throw new FileFormatException("Unexpectedly long header 65536 bytes. Possibly corrupt file.");
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        Fileformat.BlobHeader blobHeader = Fileformat.BlobHeader.parseFrom(byArray);
        FileBlockHead fileBlockHead = new FileBlockHead(blobHeader.getType(), blobHeader.getIndexdata());
        fileBlockHead.datasize = blobHeader.getDatasize();
        if (blobHeader.getDatasize() > 0x2000000) {
            throw new FileFormatException("Unexpectedly long body 33554432 bytes. Possibly corrupt file.");
        }
        fileBlockHead.input = inputStream;
        if (inputStream instanceof FileInputStream) {
            fileBlockHead.data_offset = ((FileInputStream)inputStream).getChannel().position();
        }
        return fileBlockHead;
    }

    void skipContents(InputStream inputStream) throws IOException {
        if (inputStream.skip(this.getDatasize()) != (long)this.getDatasize()) assert (false) : "SHORT READ";
    }

    FileBlock readContents(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[this.getDatasize()];
        dataInputStream.readFully(byArray);
        return this.parseData(byArray);
    }
}

