/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.MemberTypeParser;
import gama.dependencies.osmosis.RelationMember;
import gama.dependencies.osmosis.RelationMemberListener;
import org.xml.sax.Attributes;

public class RelationMemberElementProcessor
extends BaseElementProcessor {
    private static final String ATTRIBUTE_NAME_ID = "ref";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_ROLE = "role";
    private final RelationMemberListener relationMemberListener;
    private RelationMember relationMember;
    private final MemberTypeParser memberTypeParser;

    public RelationMemberElementProcessor(BaseElementProcessor baseElementProcessor, RelationMemberListener relationMemberListener) {
        super(baseElementProcessor, true);
        this.relationMemberListener = relationMemberListener;
        this.memberTypeParser = new MemberTypeParser();
    }

    @Override
    public void begin(Attributes attributes) {
        long l = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        EntityType entityType = this.memberTypeParser.parse(attributes.getValue(ATTRIBUTE_NAME_TYPE));
        String string = attributes.getValue(ATTRIBUTE_NAME_ROLE);
        if (string == null) {
            string = "";
        }
        this.relationMember = new RelationMember(l, entityType, string);
    }

    @Override
    public void end() {
        this.relationMemberListener.processRelationMember(this.relationMember);
        this.relationMember = null;
    }
}

