/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.webb;

import gama.dependencies.webb.Request;
import gama.dependencies.webb.Response;
import gama.dependencies.webb.RetryManager;
import gama.dependencies.webb.WebbException;
import gama.dependencies.webb.WebbUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Webb {
    static final String DEFAULT_USER_AGENT = "gama-platform.org/1.0";
    static final String APP_FORM = "application/x-www-form-urlencoded";
    static final String APP_JSON = "application/json";
    static final String APP_BINARY = "application/octet-stream";
    static final String TEXT_PLAIN = "text/plain";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    static final String HDR_CONTENT_ENCODING = "Content-Encoding";
    static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
    static final String HDR_ACCEPT = "Accept";
    static final String HDR_USER_AGENT = "User-Agent";
    static final String UTF8 = "utf-8";
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final Class BYTE_ARRAY_CLASS = EMPTY_BYTE_ARRAY.getClass();
    static final int MIN_COMPRESSED_ADVANTAGE = 80;
    static final Map<String, Object> globalHeaders = new LinkedHashMap<String, Object>();
    static String globalBaseUri;
    static Integer connectTimeout;
    static Integer readTimeout;
    static int jsonIndentFactor;
    Boolean followRedirects = true;
    String baseUri;
    Map<String, Object> defaultHeaders;
    SSLSocketFactory sslSocketFactory;
    HostnameVerifier hostnameVerifier;
    RetryManager retryManager;
    Proxy proxy;

    static {
        connectTimeout = 10000;
        readTimeout = 180000;
        jsonIndentFactor = -1;
    }

    protected Webb() {
    }

    public static Webb create() {
        return new Webb();
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setBaseUri(String string) {
        this.baseUri = string;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setRetryManager(RetryManager retryManager) {
        this.retryManager = retryManager;
    }

    public Request get(String string) {
        return new Request(this, Request.Method.GET, this.buildPath(string));
    }

    public Request post(String string) {
        return new Request(this, Request.Method.POST, this.buildPath(string));
    }

    public Request delete(String string) {
        return new Request(this, Request.Method.DELETE, this.buildPath(string));
    }

    private String buildPath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("pathOrUri must not be null");
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            return string;
        }
        String string2 = this.baseUri != null ? this.baseUri : globalBaseUri;
        return string2 == null ? string : string2 + string;
    }

    <T> Response<T> execute(Request request, Class<T> clazz) {
        Response<T> response = null;
        if (request.retryCount == 0) {
            response = this._execute(request, clazz);
        } else {
            if (this.retryManager == null) {
                this.retryManager = RetryManager.DEFAULT;
            }
            int n = 0;
            while (n <= request.retryCount) {
                block10: {
                    try {
                        response = this._execute(request, clazz);
                        if (n >= request.retryCount || !this.retryManager.isRetryUseful(response)) {
                            break;
                        }
                    }
                    catch (WebbException webbException) {
                        if (n < request.retryCount && this.retryManager.isRecoverable(webbException)) break block10;
                        throw webbException;
                    }
                }
                if (request.waitExponential) {
                    this.retryManager.wait(n);
                }
                ++n;
            }
        }
        if (response == null) {
            throw new IllegalStateException();
        }
        if (request.ensureSuccess) {
            response.ensureSuccess();
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Response<T> _execute(Request request, Class<T> clazz) {
        Response response;
        HttpURLConnection httpURLConnection;
        block25: {
            Response response2 = new Response(request);
            InputStream inputStream = null;
            boolean bl = true;
            httpURLConnection = null;
            try {
                block27: {
                    block26: {
                        Object object = request.uri;
                        if (request.method == Request.Method.GET && !((String)object).contains("?") && request.params != null && !request.params.isEmpty()) {
                            object = (String)object + "?" + WebbUtils.queryString(request.params);
                        }
                        URL uRL = new URL((String)object);
                        httpURLConnection = this.proxy != null ? (HttpURLConnection)uRL.openConnection(this.proxy) : (HttpURLConnection)uRL.openConnection();
                        this.prepareSslConnection(httpURLConnection);
                        httpURLConnection.setRequestMethod(request.method.name());
                        if (request.followRedirects != null) {
                            httpURLConnection.setInstanceFollowRedirects(request.followRedirects);
                        }
                        httpURLConnection.setUseCaches(request.useCaches);
                        this.setTimeouts(request, httpURLConnection);
                        if (request.ifModifiedSince != null) {
                            httpURLConnection.setIfModifiedSince(request.ifModifiedSince);
                        }
                        WebbUtils.addRequestProperties(httpURLConnection, this.mergeHeaders(request.headers));
                        if (clazz == JSONObject.class || clazz == JSONArray.class) {
                            WebbUtils.ensureRequestProperty(httpURLConnection, HDR_ACCEPT, APP_JSON);
                        }
                        if (request.method == Request.Method.GET || request.method == Request.Method.DELETE) break block26;
                        if (request.streamPayload) {
                            WebbUtils.setContentTypeAndLengthForStreaming(httpURLConnection, request, request.compress);
                            httpURLConnection.setDoOutput(true);
                            this.streamBody(httpURLConnection, request.payload, request.compress);
                            break block27;
                        } else {
                            byte[] byArray = WebbUtils.getPayloadAsBytesAndSetContentType(httpURLConnection, request, request.compress, jsonIndentFactor);
                            if (byArray != null) {
                                httpURLConnection.setDoOutput(true);
                                this.writeBody(httpURLConnection, byArray);
                            }
                        }
                        break block27;
                    }
                    httpURLConnection.connect();
                }
                response2.connection = httpURLConnection;
                response2.statusCode = httpURLConnection.getResponseCode();
                response2.responseMessage = httpURLConnection.getResponseMessage();
                inputStream = response2.isSuccess() ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                inputStream = WebbUtils.wrapStream(httpURLConnection.getContentEncoding(), inputStream);
                if (clazz == InputStream.class) {
                    inputStream = new AutoDisconnectInputStream(httpURLConnection, inputStream);
                }
                if (response2.isSuccess()) {
                    WebbUtils.parseResponseBody(clazz, response2, inputStream);
                } else {
                    WebbUtils.parseErrorResponse(clazz, response2, inputStream);
                }
                if (clazz == InputStream.class) {
                    bl = false;
                }
                response = response2;
                if (!bl) return response;
                if (inputStream == null) break block25;
            }
            catch (WebbException webbException) {
                try {
                    throw webbException;
                    catch (Exception exception) {
                        throw new WebbException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (!bl) throw throwable;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (httpURLConnection == null) throw throwable;
                    try {
                        httpURLConnection.disconnect();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (httpURLConnection == null) return response;
        try {
            httpURLConnection.disconnect();
            return response;
        }
        catch (Exception exception) {}
        return response;
    }

    private void setTimeouts(Request request, HttpURLConnection httpURLConnection) {
        if (request.connectTimeout != null || connectTimeout != null) {
            httpURLConnection.setConnectTimeout(request.connectTimeout != null ? request.connectTimeout : connectTimeout);
        }
        if (request.readTimeout != null || readTimeout != null) {
            httpURLConnection.setReadTimeout(request.readTimeout != null ? request.readTimeout : readTimeout);
        }
    }

    private void writeBody(HttpURLConnection httpURLConnection, byte[] byArray) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void streamBody(HttpURLConnection httpURLConnection, Object object, boolean bl) throws IOException {
        boolean bl2;
        InputStream inputStream;
        if (object instanceof File) {
            inputStream = new FileInputStream((File)object);
            bl2 = true;
        } else {
            inputStream = (InputStream)object;
            bl2 = false;
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (OutputStream outputStream = bl ? new GZIPOutputStream(httpURLConnection.getOutputStream()) : httpURLConnection.getOutputStream();){
                WebbUtils.copyStream(inputStream, outputStream);
                outputStream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null && bl2) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStream != null && bl2) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void prepareSslConnection(HttpURLConnection httpURLConnection) {
        if ((this.hostnameVerifier != null || this.sslSocketFactory != null) && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            if (this.hostnameVerifier != null) {
                httpsURLConnection.setHostnameVerifier(this.hostnameVerifier);
            }
            if (this.sslSocketFactory != null) {
                httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
            }
        }
    }

    Map<String, Object> mergeHeaders(Map<String, Object> map) {
        Map<String, Object> map2 = null;
        if (!globalHeaders.isEmpty()) {
            map2 = new LinkedHashMap<String, Object>();
            map2.putAll(globalHeaders);
        }
        if (this.defaultHeaders != null) {
            if (map2 == null) {
                map2 = new LinkedHashMap();
            }
            map2.putAll(this.defaultHeaders);
        }
        if (map != null) {
            if (map2 == null) {
                map2 = map;
            } else {
                map2.putAll(map);
            }
        }
        return map2;
    }

    private static class AutoDisconnectInputStream
    extends FilterInputStream {
        private final HttpURLConnection connection;

        protected AutoDisconnectInputStream(HttpURLConnection httpURLConnection, InputStream inputStream) {
            super(inputStream);
            this.connection = httpURLConnection;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.connection.disconnect();
            }
        }
    }
}

