/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFShape;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFShapeHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_SIZE = 40;
    public static final int GROUPCODE_SCALE_X = 41;
    public static final int GROUPCODE_OBLIQUE_ANGLE = 51;
    protected DXFShape shape;

    @Override
    public String getDXFEntityName() {
        return "SHAPE";
    }

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.shape;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.shape.getInsertPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.shape.getInsertPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.shape.getInsertPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 51: {
                this.shape.setObliqueAngle(dXFValue.getDoubleValue());
                break;
            }
            case 50: {
                this.shape.setRotation(dXFValue.getDoubleValue());
                break;
            }
            case 2: {
                this.shape.setName(dXFValue.getValue());
                break;
            }
            case 40: {
                this.shape.setHeight(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.shape);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.shape = new DXFShape();
    }
}

