/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kml;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import gama.dependencies.kml.AbstractObject;
import gama.dependencies.kml.Document;
import gama.dependencies.kml.Feature;
import gama.dependencies.kml.Folder;
import gama.dependencies.kml.GroundOverlay;
import gama.dependencies.kml.NamespaceFilterXMLReader;
import gama.dependencies.kml.NetworkLink;
import gama.dependencies.kml.NetworkLinkControl;
import gama.dependencies.kml.PhotoOverlay;
import gama.dependencies.kml.Placemark;
import gama.dependencies.kml.ScreenOverlay;
import gama.dependencies.kml.gx.Tour;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KmlType", propOrder={"networkLinkControl", "feature", "kmlSimpleExtension", "kmlObjectExtension"})
@XmlRootElement(name="kml", namespace="http://www.opengis.net/kml/2.2")
public class Kml
implements Cloneable {
    @XmlElement(name="NetworkLinkControl")
    protected NetworkLinkControl networkLinkControl;
    @XmlElementRef(name="AbstractFeatureGroup", namespace="http://www.opengis.net/kml/2.2", required=false)
    protected Feature feature;
    @XmlElement(name="KmlSimpleExtensionGroup")
    @XmlSchemaType(name="anySimpleType")
    protected List<Object> kmlSimpleExtension;
    @XmlElement(name="KmlObjectExtensionGroup")
    protected List<AbstractObject> kmlObjectExtension;
    @XmlAttribute(name="hint")
    protected String hint;
    private transient JAXBContext jc = null;
    private transient Marshaller m = null;
    private transient int missingNameCounter = 1;
    private static final String SCHEMA_LOCATION = "src/main/resources/schema/ogckml/ogckml22.xsd";

    public NetworkLinkControl getNetworkLinkControl() {
        return this.networkLinkControl;
    }

    public void setNetworkLinkControl(NetworkLinkControl networkLinkControl) {
        this.networkLinkControl = networkLinkControl;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public List<Object> getKmlSimpleExtension() {
        if (this.kmlSimpleExtension == null) {
            this.kmlSimpleExtension = new ArrayList<Object>();
        }
        return this.kmlSimpleExtension;
    }

    public List<AbstractObject> getKmlObjectExtension() {
        if (this.kmlObjectExtension == null) {
            this.kmlObjectExtension = new ArrayList<AbstractObject>();
        }
        return this.kmlObjectExtension;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    public int hashCode() {
        return Objects.hash(this.networkLinkControl, this.feature, this.kmlSimpleExtension, this.kmlObjectExtension, this.hint);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Kml)) {
            return false;
        }
        Kml kml = (Kml)object;
        if (!Objects.equals(this.networkLinkControl, kml.networkLinkControl)) {
            return false;
        }
        if (!Objects.equals(this.feature, kml.feature)) {
            return false;
        }
        if (!Objects.equals(this.kmlSimpleExtension, kml.kmlSimpleExtension)) {
            return false;
        }
        if (!Objects.equals(this.kmlObjectExtension, kml.kmlObjectExtension)) {
            return false;
        }
        return Objects.equals(this.hint, kml.hint);
    }

    public NetworkLinkControl createAndSetNetworkLinkControl() {
        NetworkLinkControl networkLinkControl = new NetworkLinkControl();
        this.setNetworkLinkControl(networkLinkControl);
        return networkLinkControl;
    }

    public Tour createAndSetTour() {
        Tour tour = new Tour();
        this.setFeature(tour);
        return tour;
    }

    public ScreenOverlay createAndSetScreenOverlay() {
        ScreenOverlay screenOverlay = new ScreenOverlay();
        this.setFeature(screenOverlay);
        return screenOverlay;
    }

    public PhotoOverlay createAndSetPhotoOverlay() {
        PhotoOverlay photoOverlay = new PhotoOverlay();
        this.setFeature(photoOverlay);
        return photoOverlay;
    }

    public GroundOverlay createAndSetGroundOverlay() {
        GroundOverlay groundOverlay = new GroundOverlay();
        this.setFeature(groundOverlay);
        return groundOverlay;
    }

    public NetworkLink createAndSetNetworkLink() {
        NetworkLink networkLink = new NetworkLink();
        this.setFeature(networkLink);
        return networkLink;
    }

    public Folder createAndSetFolder() {
        Folder folder = new Folder();
        this.setFeature(folder);
        return folder;
    }

    public Document createAndSetDocument() {
        Document document = new Document();
        this.setFeature(document);
        return document;
    }

    public Placemark createAndSetPlacemark() {
        Placemark placemark = new Placemark();
        this.setFeature(placemark);
        return placemark;
    }

    public void setKmlSimpleExtension(List<Object> list) {
        this.kmlSimpleExtension = list;
    }

    public Kml addToKmlSimpleExtension(Object object) {
        this.getKmlSimpleExtension().add(object);
        return this;
    }

    public void setKmlObjectExtension(List<AbstractObject> list) {
        this.kmlObjectExtension = list;
    }

    public Kml addToKmlObjectExtension(AbstractObject abstractObject) {
        this.getKmlObjectExtension().add(abstractObject);
        return this;
    }

    public Kml withNetworkLinkControl(NetworkLinkControl networkLinkControl) {
        this.setNetworkLinkControl(networkLinkControl);
        return this;
    }

    public Kml withFeature(Feature feature) {
        this.setFeature(feature);
        return this;
    }

    public Kml withKmlSimpleExtension(List<Object> list) {
        this.setKmlSimpleExtension(list);
        return this;
    }

    public Kml withKmlObjectExtension(List<AbstractObject> list) {
        this.setKmlObjectExtension(list);
        return this;
    }

    public Kml withHint(String string) {
        this.setHint(string);
        return this;
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jc == null) {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
        }
        return this.jc;
    }

    private Marshaller createMarshaller() throws JAXBException {
        if (this.m == null) {
            this.m = this.getJaxbContext().createMarshaller();
            this.m.setProperty("jaxb.formatted.output", (Object)true);
            this.m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NameSpaceBeautyfier());
        }
        return this.m;
    }

    private void addKmzFile(Kml kml, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        Object object = null;
        if (kml.getFeature() == null || kml.getFeature().getName() == null || kml.getFeature().getName().length() == 0) {
            object = "noFeatureNameSet" + this.missingNameCounter++ + ".kml";
        } else {
            object = kml.getFeature().getName();
            if (!((String)object).endsWith(".kml")) {
                object = (String)object + ".kml";
            }
        }
        if (bl) {
            object = "doc.kml";
        }
        zipOutputStream.putNextEntry(new ZipEntry(URLEncoder.encode((String)object, "UTF-8")));
        kml.marshal(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public boolean marshal(OutputStream outputStream) throws FileNotFoundException {
        try {
            this.m = this.createMarshaller();
            this.m.marshal((Object)this, outputStream);
            return true;
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return false;
        }
    }

    public boolean marshal(Writer writer) {
        try {
            this.m = this.createMarshaller();
            this.m.marshal((Object)this, writer);
            return true;
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return false;
        }
    }

    public boolean marshal(ContentHandler contentHandler) {
        try {
            this.m = this.createMarshaller();
            this.m.marshal((Object)this, contentHandler);
            return true;
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return false;
        }
    }

    public boolean marshal() {
        try {
            this.m = this.createMarshaller();
            this.m.marshal((Object)this, (OutputStream)System.out);
            return true;
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return false;
        }
    }

    public boolean marshal(File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return this.marshal(fileOutputStream);
    }

    public boolean marshalAsKmz(String string, Kml ... kmlArray) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));){
            zipOutputStream.setComment("KMZ-file created with Java API for KML. Visit us: http://code.google.com/p/javaapiforkml/");
            this.addKmzFile(this, zipOutputStream, true);
            Kml[] kmlArray2 = kmlArray;
            int n = kmlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Kml kml = kmlArray2[n2];
                this.addKmzFile(kml, zipOutputStream, false);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.missingNameCounter = 1;
        return false;
    }

    private static boolean validate(Unmarshaller unmarshaller) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File file = new File(SCHEMA_LOCATION);
            Schema schema = schemaFactory.newSchema(file);
            unmarshaller.setSchema(schema);
            return true;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return false;
        }
    }

    public static Kml unmarshal(File file, boolean bl) {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Kml.class}).createUnmarshaller();
            if (bl) {
                Kml.validate(unmarshaller);
            }
            InputSource inputSource = new InputSource(new FileReader(file));
            SAXSource sAXSource = new SAXSource(new NamespaceFilterXMLReader(bl), inputSource);
            return (Kml)unmarshaller.unmarshal((Source)sAXSource);
        }
        catch (FileNotFoundException | JAXBException | ParserConfigurationException | SAXException throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Kml unmarshal(File file) {
        return Kml.unmarshal(file, false);
    }

    public static Kml unmarshal(String string) {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Kml.class}).createUnmarshaller();
            InputSource inputSource = new InputSource(new StringReader(string));
            SAXSource sAXSource = new SAXSource(new NamespaceFilterXMLReader(false), inputSource);
            return (Kml)unmarshaller.unmarshal((Source)sAXSource);
        }
        catch (JAXBException | ParserConfigurationException | SAXException throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Kml unmarshal(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Kml.class}).createUnmarshaller();
            InputSource inputSource = new InputSource(inputStream);
            SAXSource sAXSource = new SAXSource(new NamespaceFilterXMLReader(false), inputSource);
            return (Kml)unmarshaller.unmarshal((Source)sAXSource);
        }
        catch (JAXBException | ParserConfigurationException | SAXException throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Kml[] unmarshalFromKmz(File file) throws IOException {
        Kml[] kmlArray = new Kml[]{};
        if (!file.getName().endsWith(".kmz")) {
            return kmlArray;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            if (!file.exists()) {
                return kmlArray;
            }
            ArrayList<Kml> arrayList = new ArrayList<Kml>();
            while (enumeration.hasMoreElements()) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.getName().contains("__MACOSX") || zipEntry.getName().contains(".DS_STORE") || !(string = URLDecoder.decode(zipEntry.getName(), "UTF-8")).endsWith(".kml")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Kml kml = Kml.unmarshal(inputStream);
                arrayList.add(kml);
            }
            zipFile.close();
            return arrayList.toArray(kmlArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Kml clone() {
        Kml kml;
        try {
            kml = (Kml)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        kml.networkLinkControl = this.networkLinkControl == null ? null : this.networkLinkControl.clone();
        kml.feature = this.feature == null ? null : this.feature.clone();
        kml.kmlSimpleExtension = new ArrayList<Object>(this.getKmlSimpleExtension().size());
        kml.kmlSimpleExtension.addAll(this.kmlSimpleExtension);
        kml.kmlObjectExtension = new ArrayList<AbstractObject>(this.getKmlObjectExtension().size());
        for (AbstractObject abstractObject : this.kmlObjectExtension) {
            kml.kmlObjectExtension.add(abstractObject.clone());
        }
        return kml;
    }

    private static final class NameSpaceBeautyfier
    extends NamespacePrefixMapper {
        private NameSpaceBeautyfier() {
        }

        public String getPreferredPrefix(String string, String string2, boolean bl) {
            if (string.matches("http://www.w3.org/\\d{4}/Atom")) {
                return "atom";
            }
            if (string.matches("urn:oasis:names:tc:ciq:xsdschema:xAL:.*?")) {
                return "xal";
            }
            if (string.matches("http://www.google.com/kml/ext/.*?")) {
                return "gx";
            }
            return null;
        }
    }
}

