/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.FallbackDateParser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class DateParser {
    private DatatypeFactory datatypeFactory;
    private final FallbackDateParser fallbackDateParser;
    private final Calendar calendar;

    public DateParser() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new OsmosisRuntimeException("Unable to instantiate xml datatype factory.", datatypeConfigurationException);
        }
        this.fallbackDateParser = new FallbackDateParser();
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    }

    private boolean isDateInShortStandardFormat(String string) {
        if (string.length() != 20) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray[4] != '-') {
            return false;
        }
        if (cArray[7] != '-') {
            return false;
        }
        if (cArray[10] != 'T') {
            return false;
        }
        if (cArray[13] != ':') {
            return false;
        }
        if (cArray[16] != ':') {
            return false;
        }
        if (cArray[19] != 'Z') {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 5;
        while (n < 7) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 8;
        while (n < 10) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 11;
        while (n < 13) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 14;
        while (n < 16) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 17;
        while (n < 19) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isDateInLongStandardFormat(String string) {
        if (string.length() != 24) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray[4] != '-') {
            return false;
        }
        if (cArray[7] != '-') {
            return false;
        }
        if (cArray[10] != 'T') {
            return false;
        }
        if (cArray[13] != ':') {
            return false;
        }
        if (cArray[16] != ':') {
            return false;
        }
        if (cArray[19] != '.') {
            return false;
        }
        if (cArray[23] != 'Z') {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 5;
        while (n < 7) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 8;
        while (n < 10) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 11;
        while (n < 13) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 14;
        while (n < 16) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 17;
        while (n < 19) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        n = 20;
        while (n < 23) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Date parseShortStandardDate(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        int n4 = Integer.parseInt(string.substring(11, 13));
        int n5 = Integer.parseInt(string.substring(14, 16));
        int n6 = Integer.parseInt(string.substring(17, 19));
        this.calendar.clear();
        this.calendar.set(1, n);
        this.calendar.set(2, n2 - 1);
        this.calendar.set(5, n3);
        this.calendar.set(11, n4);
        this.calendar.set(12, n5);
        this.calendar.set(13, n6);
        return this.calendar.getTime();
    }

    private Date parseLongStandardDate(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(5, 7));
        int n3 = Integer.parseInt(string.substring(8, 10));
        int n4 = Integer.parseInt(string.substring(11, 13));
        int n5 = Integer.parseInt(string.substring(14, 16));
        int n6 = Integer.parseInt(string.substring(17, 19));
        int n7 = Integer.parseInt(string.substring(20, 23));
        this.calendar.clear();
        this.calendar.set(1, n);
        this.calendar.set(2, n2 - 1);
        this.calendar.set(5, n3);
        this.calendar.set(11, n4);
        this.calendar.set(12, n5);
        this.calendar.set(13, n6);
        this.calendar.set(14, n7);
        return this.calendar.getTime();
    }

    public Date parse(String string) {
        try {
            if (this.isDateInShortStandardFormat(string)) {
                return this.parseShortStandardDate(string);
            }
            if (this.isDateInLongStandardFormat(string)) {
                return this.parseLongStandardDate(string);
            }
            return this.datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.fallbackDateParser.parse(string);
        }
    }
}

