/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Storeable;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.TimestampContainer;
import gama.dependencies.osmosis.TimestampFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class Entity
implements Storeable {
    private final CommonEntityData entityData;

    public Entity(CommonEntityData commonEntityData) {
        this.entityData = commonEntityData.getWriteableInstance();
    }

    protected Entity(Entity entity) {
        this.entityData = entity.entityData.getWriteableInstance();
    }

    public Entity(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this.entityData = new CommonEntityData(storeReader, storeClassRegister);
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        this.entityData.store(storeWriter, storeClassRegister);
    }

    protected int compareTags(Collection<Tag> collection) {
        return this.entityData.compareTags(collection);
    }

    public abstract EntityType getType();

    public long getId() {
        return this.entityData.getId();
    }

    public void setId(long l) {
        this.entityData.setId(l);
    }

    public int getVersion() {
        return this.entityData.getVersion();
    }

    public void setVersion(int n) {
        this.entityData.setVersion(n);
    }

    public Date getTimestamp() {
        return this.entityData.getTimestamp();
    }

    public void setTimestamp(Date date) {
        this.entityData.setTimestamp(date);
    }

    public TimestampContainer getTimestampContainer() {
        return this.entityData.getTimestampContainer();
    }

    public void setTimestampContainer(TimestampContainer timestampContainer) {
        this.entityData.setTimestampContainer(timestampContainer);
    }

    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        return this.entityData.getFormattedTimestamp(timestampFormat);
    }

    public OsmUser getUser() {
        return this.entityData.getUser();
    }

    public void setUser(OsmUser osmUser) {
        this.entityData.setUser(osmUser);
    }

    public long getChangesetId() {
        return this.entityData.getChangesetId();
    }

    public void setChangesetId(long l) {
        this.entityData.setChangesetId(l);
    }

    public Collection<Tag> getTags() {
        return this.entityData.getTags();
    }

    public Map<String, Object> getMetaTags() {
        return this.entityData.getMetaTags();
    }

    public boolean isReadOnly() {
        return this.entityData.isReadOnly();
    }

    protected void assertWriteable() {
        this.entityData.assertWriteable();
    }

    public void makeReadOnly() {
        this.entityData.makeReadOnly();
    }

    public abstract Entity getWriteableInstance();
}

