/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.math;

import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.math.NURBS;
import java.util.Iterator;

public class NURBSFixedNTELSPointIterator
implements Iterator {
    private NURBS nurbs;
    private int ntels;
    private double dt = 0.0;
    private double t = 0.0;
    private int interval;
    private int lastInterval;

    public NURBSFixedNTELSPointIterator(NURBS nURBS, int n) {
        this.nurbs = nURBS;
        this.ntels = n;
        if (this.nurbs.getKnots().length == this.nurbs.getDegree() + this.nurbs.controlPoints.length + 1) {
            this.lastInterval = this.nurbs.getKnots().length - this.nurbs.getDegree() - 1;
            this.interval = this.nurbs.getDegree();
        } else if (this.nurbs.getKnots().length > 0) {
            this.interval = 0;
            double d = this.nurbs.getKnots()[0];
            while (d == this.nurbs.getKnots()[this.interval + 1]) {
                ++this.interval;
            }
            this.lastInterval = this.nurbs.getKnots().length - 1;
            double d2 = this.nurbs.getKnots()[this.lastInterval];
            while (d2 == this.nurbs.getKnots()[this.lastInterval]) {
                --this.lastInterval;
            }
        }
        this.t = this.nurbs.getKnots()[this.nurbs.getDegree()];
        this.nextInterval();
        if (this.interval - 1 < this.nurbs.getDegree()) {
            this.interval = this.nurbs.getDegree() + 1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.t < this.nurbs.getKnots()[this.interval]) {
            return true;
        }
        if (this.interval < this.lastInterval) {
            this.nextInterval();
            return this.hasNext();
        }
        return false;
    }

    public Object next() {
        Point point = this.nurbs.getPointAt(this.interval - 1, this.t);
        this.t += this.dt;
        return point;
    }

    @Override
    public void remove() {
    }

    protected void nextInterval() {
        ++this.interval;
        while (this.t > this.nurbs.getKnots()[this.interval] && this.interval < this.lastInterval) {
            ++this.interval;
        }
        double d = this.nurbs.getKnots()[this.interval] - this.t;
        this.dt = d / (double)this.ntels;
    }
}

