/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFImage;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFImageHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_IMAGEDEF_HARDREFERENCE = 340;
    public static final int GROUPCODE_VECTOR_U_X = 11;
    public static final int GROUPCODE_VECTOR_U_Y = 21;
    public static final int GROUPCODE_VECTOR_U_Z = 31;
    public static final int GROUPCODE_VECTOR_V_X = 12;
    public static final int GROUPCODE_VECTOR_V_Y = 22;
    public static final int GROUPCODE_VECTOR_V_Z = 32;
    public static final int GROUPCODE_IAMGESIZE_U = 13;
    public static final int GROUPCODE_IAMGESIZE_V = 23;
    public static final int GROUPCODE_DISPLAY_PROPERTY = 70;
    public static final int GROUPCODE_BRIGHTNESS = 281;
    public static final int GROUPCODE_CONTRAST = 282;
    public static final int GROUPCODE_FADE = 283;
    public static final int GROUPCODE_NUMBER_CLIP_BOUNDARY = 91;
    public static final int GROUPCODE_CLIP_BOUNDARY_X = 14;
    public static final int GROUPCODE_CLIP_BOUNDARY_Y = 24;
    public static final int GROUPCODE_CLIP_BOUNDARY_TYPE = 71;
    public static final int GROUPCODE_CLIPPING_STATE = 280;
    protected DXFImage image;
    protected Point clippingPoint;

    @Override
    public String getDXFEntityName() {
        return "IMAGE";
    }

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.image;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.image.getInsertPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.image.getInsertPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.image.getInsertPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 340: {
                this.image.setImageDefObjectID(dXFValue.getValue());
                break;
            }
            case 11: {
                this.image.getVectorU().setX(dXFValue.getDoubleValue());
                break;
            }
            case 21: {
                this.image.getVectorU().setY(dXFValue.getDoubleValue());
                break;
            }
            case 31: {
                this.image.getVectorU().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 12: {
                this.image.getVectorV().setX(dXFValue.getDoubleValue());
                break;
            }
            case 22: {
                this.image.getVectorV().setY(dXFValue.getDoubleValue());
                break;
            }
            case 32: {
                this.image.getVectorV().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 13: {
                this.image.setImageSizeAlongU(dXFValue.getDoubleValue());
                break;
            }
            case 23: {
                this.image.setImageSizeAlongV(dXFValue.getDoubleValue());
                break;
            }
            case 280: {
                this.image.setClipping(dXFValue.getBooleanValue());
                break;
            }
            case 14: {
                this.clippingPoint = new Point();
                this.clippingPoint.setX(dXFValue.getDoubleValue());
                this.image.addClippingPoint(this.clippingPoint);
                break;
            }
            case 24: {
                this.clippingPoint.setY(dXFValue.getDoubleValue());
                break;
            }
            case 281: {
                this.image.setBrightness(dXFValue.getDoubleValue());
                break;
            }
            case 282: {
                this.image.setContrast(dXFValue.getDoubleValue());
                break;
            }
            case 283: {
                this.image.setFade(dXFValue.getDoubleValue());
                break;
            }
            case 71: {
                if (dXFValue.getIntegerValue() == 1) {
                    this.image.setRectangularClipping(true);
                    break;
                }
                if (dXFValue.getIntegerValue() != 2) break;
                this.image.setPolygonalClipping(true);
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.image);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.image = new DXFImage();
        this.image.setDXFDocument(this.doc);
    }
}

