/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BinaryParser;
import gama.dependencies.osmosis.Bound;
import gama.dependencies.osmosis.BoundContainer;
import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.Node;
import gama.dependencies.osmosis.NodeContainer;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.Osmformat;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Relation;
import gama.dependencies.osmosis.RelationContainer;
import gama.dependencies.osmosis.RelationMember;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.Way;
import gama.dependencies.osmosis.WayContainer;
import gama.dependencies.osmosis.WayNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OsmosisBinaryParser
extends BinaryParser {
    static final int NOVERSION = -1;
    static final int NOCHANGESET = -1;
    private Sink sink;

    @Override
    public void complete() {
        this.sink.complete();
    }

    OsmUser getUser(Osmformat.Info info) {
        if (info.hasUid() && info.hasUserSid()) {
            if (info.getUid() < 0) {
                return OsmUser.NONE;
            }
            return new OsmUser(info.getUid(), this.getStringById(info.getUserSid()));
        }
        return OsmUser.NONE;
    }

    @Override
    protected void parseNodes(List<Osmformat.Node> list) {
        for (Osmformat.Node node : list) {
            Node node2;
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            int n = 0;
            while (n < node.getKeysCount()) {
                arrayList.add(new Tag(this.getStringById(node.getKeys(n)), this.getStringById(node.getVals(n))));
                ++n;
            }
            long l = node.getId();
            double d = this.parseLat(node.getLat());
            double d2 = this.parseLon(node.getLon());
            if (node.hasInfo()) {
                Osmformat.Info info = node.getInfo();
                node2 = new Node(new CommonEntityData(l, info.getVersion(), this.getDate(info), this.getUser(info), info.getChangeset(), arrayList), d, d2);
            } else {
                node2 = new Node(new CommonEntityData(l, -1, NODATE, OsmUser.NONE, -1L, arrayList), d, d2);
            }
            this.sink.process(new NodeContainer(node2));
        }
    }

    @Override
    protected void parseDense(Osmformat.DenseNodes denseNodes) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        long l4 = 0L;
        long l5 = 0L;
        int n2 = 0;
        int n3 = 0;
        Osmformat.DenseInfo denseInfo = null;
        if (denseNodes.hasDenseinfo()) {
            denseInfo = denseNodes.getDenseinfo();
        }
        int n4 = 0;
        while (n4 < denseNodes.getIdCount()) {
            Node node;
            int n5;
            int n6;
            long l6;
            long l7;
            long l8;
            ArrayList<Tag> arrayList = new ArrayList<Tag>(0);
            l2 = l8 = denseNodes.getLat(n4) + l2;
            l3 = l7 = denseNodes.getLon(n4) + l3;
            l = l6 = denseNodes.getId(n4) + l;
            double d = this.parseLat(l8);
            double d2 = this.parseLon(l7);
            if (denseNodes.getKeysValsCount() > 0) {
                while (denseNodes.getKeysVals(n) != 0) {
                    n6 = denseNodes.getKeysVals(n++);
                    n5 = denseNodes.getKeysVals(n++);
                    arrayList.add(new Tag(this.getStringById(n6), this.getStringById(n5)));
                }
                ++n;
            }
            if (denseInfo != null) {
                long l9;
                long l10;
                n3 = n6 = denseInfo.getUid(n4) + n3;
                n2 = n5 = denseInfo.getUserSid(n4) + n2;
                l4 = l10 = denseInfo.getTimestamp(n4) + l4;
                int n7 = denseInfo.getVersion(n4);
                l5 = l9 = denseInfo.getChangeset(n4) + l5;
                Date date = new Date((long)this.date_granularity * l10);
                OsmUser osmUser = n6 < 0 ? OsmUser.NONE : new OsmUser(n6, this.getStringById(n5));
                node = new Node(new CommonEntityData(l6, n7, date, osmUser, l9, arrayList), d, d2);
            } else {
                node = new Node(new CommonEntityData(l6, -1, NODATE, OsmUser.NONE, -1L, arrayList), d, d2);
            }
            this.sink.process(new NodeContainer(node));
            ++n4;
        }
    }

    @Override
    protected void parseWays(List<Osmformat.Way> list) {
        for (Osmformat.Way way : list) {
            Way way2;
            Object object;
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            int n = 0;
            while (n < way.getKeysCount()) {
                arrayList.add(new Tag(this.getStringById(way.getKeys(n)), this.getStringById(way.getVals(n))));
                ++n;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            ArrayList<WayNode> arrayList2 = new ArrayList<WayNode>();
            int n2 = 0;
            while (n2 < way.getRefsCount()) {
                long l4 = l + way.getRefs(n2);
                if (n2 < way.getLatCount() && n2 < way.getLonCount()) {
                    long l5 = l2 + way.getLat(n2);
                    long l6 = l3 + way.getLon(n2);
                    object = new WayNode(l4, this.parseLat(l5), this.parseLon(l6));
                    l2 = l5;
                    l3 = l6;
                } else {
                    object = new WayNode(l4);
                }
                arrayList2.add((WayNode)object);
                l = l4;
                ++n2;
            }
            long l7 = way.getId();
            if (way.hasInfo()) {
                object = way.getInfo();
                way2 = new Way(new CommonEntityData(l7, ((Osmformat.Info)object).getVersion(), this.getDate((Osmformat.Info)object), this.getUser((Osmformat.Info)object), ((Osmformat.Info)object).getChangeset(), arrayList), arrayList2);
            } else {
                way2 = new Way(new CommonEntityData(l7, -1, NODATE, OsmUser.NONE, -1L, arrayList), arrayList2);
            }
            this.sink.process(new WayContainer(way2));
        }
    }

    @Override
    protected void parseRelations(List<Osmformat.Relation> list) {
        for (Osmformat.Relation relation : list) {
            Relation relation2;
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            int n = 0;
            while (n < relation.getKeysCount()) {
                arrayList.add(new Tag(this.getStringById(relation.getKeys(n)), this.getStringById(relation.getVals(n))));
                ++n;
            }
            long l = relation.getId();
            long l2 = 0L;
            ArrayList<RelationMember> arrayList2 = new ArrayList<RelationMember>();
            int n2 = 0;
            while (n2 < relation.getMemidsCount()) {
                long l3;
                l2 = l3 = l2 + relation.getMemids(n2);
                String string = this.getStringById(relation.getRolesSid(n2));
                EntityType entityType = null;
                if (relation.getTypes(n2) == Osmformat.Relation.MemberType.NODE) {
                    entityType = EntityType.Node;
                } else if (relation.getTypes(n2) == Osmformat.Relation.MemberType.WAY) {
                    entityType = EntityType.Way;
                } else if (relation.getTypes(n2) == Osmformat.Relation.MemberType.RELATION) {
                    entityType = EntityType.Relation;
                } else assert (false);
                arrayList2.add(new RelationMember(l3, entityType, string));
                ++n2;
            }
            if (relation.hasInfo()) {
                Osmformat.Info info = relation.getInfo();
                relation2 = new Relation(new CommonEntityData(l, info.getVersion(), this.getDate(info), this.getUser(info), info.getChangeset(), arrayList), arrayList2);
            } else {
                relation2 = new Relation(new CommonEntityData(l, -1, NODATE, OsmUser.NONE, -1L, arrayList), arrayList2);
            }
            this.sink.process(new RelationContainer(relation2));
        }
    }

    @Override
    public void parse(Osmformat.HeaderBlock headerBlock) {
        for (String string : headerBlock.getRequiredFeaturesList()) {
            if (string.equals("OsmSchema-V0.6") || string.equals("DenseNodes")) continue;
            throw new OsmosisRuntimeException("File requires unknown feature: " + string);
        }
        if (headerBlock.hasBbox()) {
            String string;
            string = "no-version-specified";
            if (headerBlock.hasSource()) {
                string = headerBlock.getSource();
            }
            double d = (double)headerBlock.getBbox().getRight() * 1.0E-9;
            double d2 = (double)headerBlock.getBbox().getLeft() * 1.0E-9;
            double d3 = (double)headerBlock.getBbox().getTop() * 1.0E-9;
            double d4 = (double)headerBlock.getBbox().getBottom() * 1.0E-9;
            Bound bound = new Bound(d, d2, d3, d4, string);
            this.sink.process(new BoundContainer(bound));
        }
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

