/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Storeable;

public class RelationMember
implements Comparable<RelationMember>,
Storeable {
    private final long memberId;
    private final EntityType memberType;
    private final String memberRole;

    public RelationMember(long l, EntityType entityType, String string) {
        this.memberId = l;
        this.memberType = entityType;
        this.memberRole = string;
        if (entityType == null) {
            throw new IllegalArgumentException("null type given for relation-member");
        }
        if (string == null) {
            throw new IllegalArgumentException("null role given for relation-member");
        }
    }

    public RelationMember(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this(storeReader.readLong(), EntityType.valueOf(storeReader.readString()), storeReader.readString());
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        storeWriter.writeLong(this.memberId);
        storeWriter.writeString(this.memberType.toString());
        storeWriter.writeString(this.memberRole);
    }

    @Override
    public int compareTo(RelationMember relationMember) {
        long l = this.memberType.compareTo(relationMember.memberType);
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        l = this.memberId - relationMember.memberId;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        l = this.memberRole.compareTo(relationMember.memberRole);
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    public long getMemberId() {
        return this.memberId;
    }

    public EntityType getMemberType() {
        return this.memberType;
    }

    public String getMemberRole() {
        return this.memberRole;
    }

    public String toString() {
        return "RelationMember(" + String.valueOf((Object)this.getMemberType()) + " with id " + this.getMemberId() + " in the role '" + this.getMemberRole() + "')";
    }
}

