/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.math.MathUtils;
import gama.dependencies.kabeja.math.ParametricPlane;

public class DXFArc
extends DXFEntity {
    private Point center = new Point();
    private double radius;
    private double start_angle;
    private double end_angle;
    private boolean counterclockwise = false;

    public double getEndAngle() {
        return this.end_angle;
    }

    public void setEndAngle(double d) {
        this.end_angle = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public double getStartAngle() {
        return this.start_angle;
    }

    public void setStartAngle(double d) {
        this.start_angle = d;
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Point point = this.getStartPoint();
        Point point2 = this.getEndPoint();
        bounds.addToBounds(point);
        bounds.addToBounds(point2);
        ParametricPlane parametricPlane = new ParametricPlane(this.getExtrusion());
        Point point3 = parametricPlane.getPoint(this.center.getX(), this.center.getY());
        int n = MathUtils.getQuadrant(point, point3);
        int n2 = MathUtils.getQuadrant(point2, point3);
        if (n2 < n) {
            n2 += 4;
        }
        while (n2 > n) {
            switch (n) {
                case 0: {
                    bounds.addToBounds(point3.getX(), point3.getY() + this.radius, point3.getZ());
                    break;
                }
                case 1: {
                    bounds.addToBounds(point3.getX() - this.radius, point3.getY(), point3.getZ());
                    break;
                }
                case 2: {
                    bounds.addToBounds(point3.getX(), point3.getY() - this.radius, point3.getZ());
                    break;
                }
                case 3: {
                    bounds.addToBounds(point3.getX() + this.radius, point3.getY(), point3.getZ());
                    n2 -= 4;
                    n -= 4;
                }
            }
            ++n;
        }
        return bounds;
    }

    public void setCenterPoint(Point point) {
        this.center = point;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Point getStartPoint() {
        double d = this.start_angle;
        return this.getPointAt(d);
    }

    public Point getEndPoint() {
        double d = this.end_angle;
        return this.getPointAt(d);
    }

    public Point getPointAt(double d) {
        double d2 = this.radius * Math.cos(Math.toRadians(d));
        double d3 = this.radius * Math.sin(Math.toRadians(d));
        ParametricPlane parametricPlane = new ParametricPlane(this.getExtrusion());
        Point point = parametricPlane.getPoint(d2 + this.center.getX(), d3 + this.center.getY());
        return point;
    }

    @Override
    public String getType() {
        return "ARC";
    }

    @Override
    public double getLength() {
        double d = this.getTotalAngle();
        return d * Math.PI * this.radius / 180.0;
    }

    public double getTotalAngle() {
        if (this.end_angle < this.start_angle) {
            return 360.0 + this.end_angle - this.start_angle;
        }
        return Math.abs(this.end_angle - this.start_angle);
    }

    public double getChordLength() {
        double d = 2.0 * this.radius * Math.sin(Math.toRadians(this.getTotalAngle() / 2.0));
        return d;
    }

    public boolean isCounterClockwise() {
        return this.counterclockwise;
    }

    public void setCounterClockwise(boolean bl) {
        this.counterclockwise = bl;
    }
}

