/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.DXFPolyline;
import gama.dependencies.kabeja.dxf.DXFSpline;
import gama.dependencies.kabeja.dxf.DXFVertex;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.SplinePoint;
import gama.dependencies.kabeja.math.NURBS;
import gama.dependencies.kabeja.math.NURBSFixedNTELSPointIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class DXFSplineConverter {
    public static DXFPolyline toDXFPolyline(DXFSpline dXFSpline) {
        DXFPolyline dXFPolyline = new DXFPolyline();
        dXFPolyline.setDXFDocument(dXFSpline.getDXFDocument());
        if (dXFSpline.getDegree() > 0 && dXFSpline.getKnots().length > 0) {
            NURBSFixedNTELSPointIterator nURBSFixedNTELSPointIterator = new NURBSFixedNTELSPointIterator(DXFSplineConverter.toNurbs(dXFSpline), 30);
            while (nURBSFixedNTELSPointIterator.hasNext()) {
                dXFPolyline.addVertex(new DXFVertex((Point)nURBSFixedNTELSPointIterator.next()));
            }
        } else {
            Iterator iterator = dXFSpline.getSplinePointIterator();
            while (iterator.hasNext()) {
                SplinePoint splinePoint = (SplinePoint)iterator.next();
                if (!splinePoint.isControlPoint()) continue;
                dXFPolyline.addVertex(new DXFVertex(splinePoint));
            }
        }
        if (dXFSpline.isClosed()) {
            dXFPolyline.setFlags(1);
        }
        return dXFPolyline;
    }

    public static NURBS toNurbs(DXFSpline dXFSpline) {
        Object object;
        Iterator iterator = dXFSpline.getSplinePointIterator();
        ArrayList<SplinePoint> arrayList = new ArrayList<SplinePoint>();
        while (iterator.hasNext()) {
            object = (SplinePoint)iterator.next();
            if (!((SplinePoint)object).isControlPoint()) continue;
            arrayList.add((SplinePoint)object);
        }
        object = new NURBS(arrayList.toArray(new Point[arrayList.size()]), dXFSpline.getKnots(), dXFSpline.getWeights(), dXFSpline.getDegree());
        ((NURBS)object).setClosed(dXFSpline.isClosed());
        return object;
    }
}

