/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;
import gama.dependencies.kabeja.math.MathUtils;

public class ParametricLine {
    protected Point startPoint;
    protected Vector direction;

    public ParametricLine(Point point, Vector vector) {
        this.startPoint = point;
        this.direction = vector;
    }

    public ParametricLine(Point point, Point point2) {
        this.startPoint = point;
        this.direction = MathUtils.getVector(point, point2);
    }

    public ParametricLine() {
        this(new Point(), new Point());
    }

    public double getIntersectionParameter(ParametricLine parametricLine) {
        Vector vector = MathUtils.crossProduct(this.direction, parametricLine.getDirectionVector());
        if (MathUtils.absoluteValue(vector) == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        Vector vector2 = MathUtils.crossProduct(MathUtils.getVector(this.startPoint, parametricLine.getStartPoint()), parametricLine.getDirectionVector());
        double d = 0.0;
        if (vector.getX() != 0.0) {
            d = vector2.getX() / vector.getX();
        } else if (vector.getY() != 0.0) {
            d = vector2.getY() / vector.getY();
        } else if (vector.getZ() != 0.0) {
            d = vector2.getZ() / vector.getZ();
        }
        return d;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point point) {
        this.startPoint = point;
    }

    public Vector getDirectionVector() {
        return this.direction;
    }

    public void setDirectionVector(Vector vector) {
        this.direction = vector;
    }

    public Point getPointAt(double d) {
        return MathUtils.getPointOfStraightLine(this.startPoint, this.direction, d);
    }

    public double getParameter(Point point) {
        double d = 0.0;
        if (this.direction.getX() != 0.0) {
            d = (point.getX() - this.startPoint.getX()) / this.direction.getX();
        } else if (this.direction.getY() != 0.0) {
            d = (point.getY() - this.startPoint.getY()) / this.direction.getY();
        } else if (this.direction.getZ() != 0.0) {
            d = (point.getZ() - this.startPoint.getZ()) / this.direction.getZ();
        }
        return d;
    }
}

