/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.math;

import gama.dependencies.kabeja.dxf.DXFExtrusion;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;
import gama.dependencies.kabeja.math.MathUtils;

public class ParametricPlane {
    protected Point base;
    protected Vector directionX;
    protected Vector directionY;
    protected Vector normal;

    public ParametricPlane(Point point, Vector vector, Vector vector2, Vector vector3) {
        this.base = point;
        this.directionX = vector;
        this.directionY = vector2;
        this.normal = vector3;
    }

    public ParametricPlane(Point point, Vector vector, Vector vector2) {
        this(point, vector, vector2, MathUtils.normalize(MathUtils.crossProduct(vector, vector2)));
    }

    public ParametricPlane(Point point, Point point2, Vector vector) {
        this(point, MathUtils.normalize(MathUtils.getVector(point, point2)), MathUtils.normalize(MathUtils.crossProduct(vector, MathUtils.normalize(MathUtils.getVector(point, point2)))), vector);
    }

    public ParametricPlane(Point point, Point point2, Point point3) {
        this(point, MathUtils.normalize(MathUtils.getVector(point, point2)), MathUtils.normalize(MathUtils.getVector(point, point3)));
    }

    public ParametricPlane(DXFExtrusion dXFExtrusion) {
        this(new Point(0.0, 0.0, 0.0), dXFExtrusion.getDirectionX(), dXFExtrusion.getDirectionY(), dXFExtrusion.getNormal());
    }

    public Point getPoint(double d, double d2) {
        Point point = new Point();
        point.setX(this.base.getX() + this.directionX.getX() * d + this.directionY.getX() * d2);
        point.setY(this.base.getY() + this.directionX.getY() * d + this.directionY.getY() * d2);
        point.setZ(this.base.getZ() + this.directionX.getZ() * d + this.directionY.getZ() * d2);
        return point;
    }

    public Point getPoint(Point point) {
        return this.getPoint(point.getX(), point.getY());
    }

    public double[] getParameter(Point point) {
        double d = 0.0;
        double d2 = this.directionX.getY() * this.directionY.getX() - this.directionX.getX() * this.directionY.getY();
        if (d2 != 0.0) {
            d2 = (point.getY() * this.directionY.getX() - this.base.getY() * this.directionY.getX() - this.directionY.getY() * point.getX() + this.base.getX() * this.directionY.getY()) / d2;
        }
        if (this.directionY.getX() != 0.0) {
            d = (point.getX() - this.base.getX() - this.directionX.getX() * d2) / this.directionY.getX();
        } else if (this.directionY.getY() != 0.0) {
            d = (point.getY() - this.base.getY() - this.directionX.getY() * d2) / this.directionY.getY();
        } else if (this.directionY.getY() != 0.0) {
            d = (point.getZ() - this.base.getZ() - this.directionX.getZ() * d2) / this.directionY.getZ();
        }
        return new double[]{d2, d};
    }

    public boolean isOnPlane(Point point) {
        double[] dArray = this.getParameter(point);
        double d = this.base.getZ() + this.directionX.getZ() * dArray[0] + this.directionY.getZ() * dArray[1];
        if (!(Math.abs(point.getZ() - d) < 1.0E-5)) {
            return false;
        }
        d = this.base.getY() + this.directionX.getY() * dArray[0] + this.directionY.getY() * dArray[1];
        if (!(Math.abs(point.getY() - d) < 1.0E-5)) {
            return false;
        }
        d = this.base.getX() + this.directionX.getX() * dArray[0] + this.directionY.getX() * dArray[1];
        return Math.abs(point.getX() - d) < 1.0E-5;
    }

    public Point getBasePoint() {
        return this.base;
    }

    public void setBasePoint(Point point) {
        this.base = point;
    }

    public Vector getDirectionX() {
        return this.directionX;
    }

    public void setDirectionX(Vector vector) {
        this.directionX = vector;
        this.normal = MathUtils.crossProduct(this.directionX, this.directionY);
        this.normal.normalize();
    }

    public Vector getDirectionY() {
        return this.directionY;
    }

    public void setDirectionY(Vector vector) {
        this.directionY = vector;
        this.normal = MathUtils.crossProduct(this.directionX, this.directionY);
        this.normal.normalize();
    }

    public Vector getNormal() {
        return this.normal;
    }
}

