/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import com.google.protobuf.InvalidProtocolBufferException;
import gama.dependencies.osmosis.BlockReaderAdapter;
import gama.dependencies.osmosis.FileBlock;
import gama.dependencies.osmosis.FileBlockPosition;
import gama.dependencies.osmosis.Osmformat;
import java.util.Date;
import java.util.List;

public abstract class BinaryParser
implements BlockReaderAdapter {
    protected int granularity;
    private long lat_offset;
    private long lon_offset;
    protected int date_granularity;
    private String[] strings;
    public static final Date NODATE = new Date(-1L);

    protected Date getDate(Osmformat.Info info) {
        if (info.hasTimestamp()) {
            return new Date((long)this.date_granularity * info.getTimestamp());
        }
        return NODATE;
    }

    protected String getStringById(int n) {
        return this.strings[n];
    }

    @Override
    public void handleBlock(FileBlock fileBlock) {
        try {
            if (fileBlock.getType().equals("OSMHeader")) {
                Osmformat.HeaderBlock headerBlock = Osmformat.HeaderBlock.parseFrom(fileBlock.getData());
                this.parse(headerBlock);
            } else if (fileBlock.getType().equals("OSMData")) {
                Osmformat.PrimitiveBlock primitiveBlock = Osmformat.PrimitiveBlock.parseFrom(fileBlock.getData());
                this.parse(primitiveBlock);
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            invalidProtocolBufferException.printStackTrace();
            throw new Error("ParseError");
        }
    }

    @Override
    public boolean skipBlock(FileBlockPosition fileBlockPosition) {
        if (fileBlockPosition.getType().equals("OSMData")) {
            return false;
        }
        if (fileBlockPosition.getType().equals("OSMHeader")) {
            return false;
        }
        System.out.println("Skipped block of type: " + fileBlockPosition.getType());
        return true;
    }

    public double parseLat(long l) {
        return (double)((long)this.granularity * l + this.lat_offset) * 1.0E-9;
    }

    public double parseLon(long l) {
        return (double)((long)this.granularity * l + this.lon_offset) * 1.0E-9;
    }

    public void parse(Osmformat.PrimitiveBlock primitiveBlock) {
        Osmformat.StringTable stringTable = primitiveBlock.getStringtable();
        this.strings = new String[stringTable.getSCount()];
        int n = 0;
        while (n < this.strings.length) {
            this.strings[n] = stringTable.getS(n).toStringUtf8();
            ++n;
        }
        this.granularity = primitiveBlock.getGranularity();
        this.lat_offset = primitiveBlock.getLatOffset();
        this.lon_offset = primitiveBlock.getLonOffset();
        this.date_granularity = primitiveBlock.getDateGranularity();
        for (Osmformat.PrimitiveGroup primitiveGroup : primitiveBlock.getPrimitivegroupList()) {
            this.parseNodes(primitiveGroup.getNodesList());
            this.parseWays(primitiveGroup.getWaysList());
            this.parseRelations(primitiveGroup.getRelationsList());
            if (!primitiveGroup.hasDense()) continue;
            this.parseDense(primitiveGroup.getDense());
        }
    }

    protected abstract void parseRelations(List<Osmformat.Relation> var1);

    protected abstract void parseDense(Osmformat.DenseNodes var1);

    protected abstract void parseNodes(List<Osmformat.Node> var1);

    protected abstract void parseWays(List<Osmformat.Way> var1);

    protected abstract void parse(Osmformat.HeaderBlock var1);
}

