/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.Bound;
import gama.dependencies.osmosis.BoundContainer;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.SourceElementProcessor;
import org.xml.sax.Attributes;

public class LegacyBoundElementProcessor
extends SourceElementProcessor {
    private static final String ATTRIBUTE_NAME_BOX = "box";
    private static final String ATTRIBUTE_NAME_ORIGIN = "origin";
    private Bound bound;

    public LegacyBoundElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl) {
        super(baseElementProcessor, sink, bl);
    }

    @Override
    public void begin(Attributes attributes) {
        Double d;
        Double d2;
        Double d3;
        Double d4;
        String string = attributes.getValue(ATTRIBUTE_NAME_BOX);
        if (string == null) {
            throw new OsmosisRuntimeException("Missing required box attribute of bound element");
        }
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new OsmosisRuntimeException("Badly formed box attribute of bound element");
        }
        try {
            d4 = Double.parseDouble(stringArray[0]);
            d3 = Double.parseDouble(stringArray[1]);
            d2 = Double.parseDouble(stringArray[2]);
            d = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmosisRuntimeException("Can't parse box attribute of bound element", numberFormatException);
        }
        String string2 = attributes.getValue(ATTRIBUTE_NAME_ORIGIN);
        if (string2 == null || string2.equals("")) {
            throw new OsmosisRuntimeException("Origin attribute of bound element is empty or missing.");
        }
        this.bound = new Bound(d, d3, d2, d4, string2);
    }

    @Override
    public void end() {
        this.getSink().process(new BoundContainer(this.bound));
        this.bound = null;
    }
}

