/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.webb;

import gama.dependencies.webb.Request;
import gama.dependencies.webb.Response;
import gama.dependencies.webb.Webb;
import gama.dependencies.webb.WebbException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class WebbUtils {
    protected WebbUtils() {
    }

    public static String queryString(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    WebbUtils.appendParam(stringBuilder, string, entry.getKey(), object2);
                    string = "&";
                    ++n2;
                }
                continue;
            }
            if (object instanceof Iterable) {
                for (Object object2 : (Iterable)object) {
                    WebbUtils.appendParam(stringBuilder, string, entry.getKey(), object2);
                    string = "&";
                }
                continue;
            }
            WebbUtils.appendParam(stringBuilder, string, entry.getKey(), object);
            string = "&";
        }
        return stringBuilder.toString();
    }

    private static void appendParam(StringBuilder stringBuilder, String string, String string2, Object object) {
        String string3 = object == null ? "" : String.valueOf(object);
        stringBuilder.append(string);
        stringBuilder.append(WebbUtils.urlEncode(string2));
        stringBuilder.append('=');
        stringBuilder.append(WebbUtils.urlEncode(string3));
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WebbUtils.copyStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static DateFormat getRfc1123DateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        simpleDateFormat.setLenient(false);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static void addRequestProperties(HttpURLConnection httpURLConnection, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            WebbUtils.addRequestProperty(httpURLConnection, entry.getKey(), entry.getValue());
        }
    }

    static void addRequestProperty(HttpURLConnection httpURLConnection, String string, Object object) {
        if (string == null || string.length() == 0 || object == null) {
            throw new IllegalArgumentException("name and value must not be empty");
        }
        String string2 = object instanceof Date ? WebbUtils.getRfc1123DateFormat().format((Date)object) : (object instanceof Calendar ? WebbUtils.getRfc1123DateFormat().format(((Calendar)object).getTime()) : object.toString());
        httpURLConnection.addRequestProperty(string, string2);
    }

    static void ensureRequestProperty(HttpURLConnection httpURLConnection, String string, Object object) {
        if (!httpURLConnection.getRequestProperties().containsKey(string)) {
            WebbUtils.addRequestProperty(httpURLConnection, string, object);
        }
    }

    static byte[] getPayloadAsBytesAndSetContentType(HttpURLConnection httpURLConnection, Request request, boolean bl, int n) throws UnsupportedEncodingException {
        byte[] byArray;
        byte[] byArray2 = null;
        String string = null;
        if (request.params != null) {
            WebbUtils.ensureRequestProperty(httpURLConnection, "Content-Type", "application/x-www-form-urlencoded");
            string = WebbUtils.queryString(request.params);
        } else {
            if (request.payload == null) {
                return null;
            }
            if (request.payload instanceof byte[]) {
                WebbUtils.ensureRequestProperty(httpURLConnection, "Content-Type", "application/octet-stream");
                byArray2 = (byte[])request.payload;
            } else {
                WebbUtils.ensureRequestProperty(httpURLConnection, "Content-Type", "text/plain");
                string = request.payload.toString();
            }
        }
        if (string != null) {
            byArray2 = string.getBytes("utf-8");
        }
        if (byArray2 == null) {
            throw new IllegalStateException();
        }
        if (bl && byArray2.length > 80 && byArray2.length - (byArray = WebbUtils.gzip(byArray2)).length > 80) {
            byArray2 = byArray;
            httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
        }
        httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
        return byArray2;
    }

    static void setContentTypeAndLengthForStreaming(HttpURLConnection httpURLConnection, Request request, boolean bl) {
        long l;
        if (request.payload instanceof File) {
            l = bl ? -1L : ((File)request.payload).length();
        } else if (request.payload instanceof InputStream) {
            l = -1L;
        } else {
            throw new IllegalStateException();
        }
        if (l > Integer.MAX_VALUE) {
            l = -1L;
        }
        WebbUtils.ensureRequestProperty(httpURLConnection, "Content-Type", "application/octet-stream");
        if (l < 0L) {
            httpURLConnection.setChunkedStreamingMode(-1);
            if (bl) {
                httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
            }
        } else {
            httpURLConnection.setFixedLengthStreamingMode((int)l);
        }
    }

    /*
     * Loose catch block
     */
    static byte[] gzip(byte[] byArray) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray2;
                GZIPOutputStream gZIPOutputStream;
                ByteArrayOutputStream byteArrayOutputStream;
                block18: {
                    block17: {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                        gZIPOutputStream.write(byArray);
                        gZIPOutputStream.flush();
                        byArray2 = byteArrayOutputStream.toByteArray();
                        if (gZIPOutputStream == null) break block17;
                        gZIPOutputStream.close();
                    }
                    if (byteArrayOutputStream == null) break block18;
                    byteArrayOutputStream.close();
                }
                return byArray2;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (gZIPOutputStream != null) {
                                gZIPOutputStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new WebbException(exception);
        }
    }

    static InputStream wrapStream(String string, InputStream inputStream) throws IOException {
        if (string == null || "identity".equalsIgnoreCase(string)) {
            return inputStream;
        }
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream, new Inflater(false), 512);
        }
        throw new WebbException("unsupported content-encoding: " + string);
    }

    static <T> void parseResponseBody(Class<T> clazz, Response<T> response, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        if (inputStream == null || clazz == Void.class) {
            return;
        }
        if (clazz == InputStream.class) {
            response.setBody(inputStream);
            return;
        }
        byte[] byArray = WebbUtils.readBytes(inputStream);
        if (clazz == String.class) {
            response.setBody(new String(byArray, "utf-8"));
        } else if (clazz == Webb.BYTE_ARRAY_CLASS) {
            response.setBody(byArray);
        }
    }

    static <T> void parseErrorResponse(Class<T> clazz, Response<T> response, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        if (inputStream == null) {
            return;
        }
        if (clazz == InputStream.class) {
            response.errorBody = inputStream;
            return;
        }
        byte[] byArray = WebbUtils.readBytes(inputStream);
        String string = response.connection.getContentType();
        if (string == null || string.startsWith("application/octet-stream") || clazz == Webb.BYTE_ARRAY_CLASS) {
            response.errorBody = byArray;
            return;
        }
        try {
            response.errorBody = new String(byArray, "utf-8");
            return;
        }
        catch (Exception exception) {
            response.errorBody = byArray;
            return;
        }
    }
}

