/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kml;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Coordinate", namespace="http://www.opengis.net/kml/2.2")
public class Coordinate
implements Cloneable {
    protected double longitude;
    protected double latitude;
    protected double altitude;

    public Coordinate(double d, double d2) {
        this.longitude = d;
        this.latitude = d2;
    }

    public Coordinate(double d, double d2, double d3) {
        this.longitude = d;
        this.latitude = d2;
        this.altitude = d3;
    }

    public Coordinate(String string) {
        String[] stringArray = string.replaceAll(",\\s+", ",").trim().split(",");
        if (stringArray.length < 1 && stringArray.length > 3) {
            throw new IllegalArgumentException();
        }
        this.longitude = Double.parseDouble(stringArray[0]);
        this.latitude = Double.parseDouble(stringArray[1]);
        if (stringArray.length == 3) {
            this.altitude = Double.parseDouble(stringArray[2]);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.longitude);
        stringBuilder.append(",");
        stringBuilder.append(this.latitude);
        if (this.altitude != 0.0) {
            stringBuilder.append(",");
            stringBuilder.append(this.altitude);
        }
        return stringBuilder.toString();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Coordinate setLongitude(double d) {
        this.longitude = d;
        return this;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Coordinate setLatitude(double d) {
        this.latitude = d;
        return this;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Coordinate setAltitude(double d) {
        this.altitude = d;
        return this;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.longitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.latitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.altitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Coordinate)) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        if (this.longitude != coordinate.longitude) {
            return false;
        }
        if (this.latitude != coordinate.latitude) {
            return false;
        }
        return this.altitude == coordinate.altitude;
    }

    public Coordinate withLongitude(double d) {
        this.setLongitude(d);
        return this;
    }

    public Coordinate withLatitude(double d) {
        this.setLatitude(d);
        return this;
    }

    public Coordinate withAltitude(double d) {
        this.setAltitude(d);
        return this;
    }

    public Coordinate clone() {
        Coordinate coordinate;
        try {
            coordinate = (Coordinate)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        return coordinate;
    }
}

