/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser;

import gama.dependencies.kabeja.parser.AbstractSectionHandler;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.Handler;
import gama.dependencies.kabeja.parser.HandlerManager;
import gama.dependencies.kabeja.parser.table.DXFTableHandler;
import java.util.Hashtable;

public class DXFTableSectionHandler
extends AbstractSectionHandler
implements HandlerManager {
    public static final String sectionKey = "TABLES";
    public static final String TABLE_START = "TABLE";
    public static final String TABLE_END = "ENDTAB";
    public final int TABLE_CODE = 0;
    private String table = "";
    private DXFTableHandler handler;
    private final Hashtable<String, DXFTableHandler> handlers = new Hashtable();
    private boolean parse = false;

    @Override
    public String getSectionKey() {
        return sectionKey;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        if (n == 0) {
            if (TABLE_END.equals(dXFValue.toString())) {
                this.table = "";
                if (this.parse) {
                    this.handler.endParsing();
                    this.parse = false;
                }
            } else if (!TABLE_START.equals(dXFValue.toString())) {
                if (this.parse) {
                    this.handler.endParsing();
                }
                this.table = dXFValue.getValue();
                if (this.handlers.containsKey(this.table)) {
                    this.handler = this.handlers.get(this.table);
                    this.handler.setDXFDocument(this.doc);
                    this.handler.startParsing();
                    this.parse = true;
                } else {
                    this.parse = false;
                }
            }
        } else if (this.parse) {
            this.handler.parseGroup(n, dXFValue);
        }
    }

    @Override
    public void endSection() {
    }

    @Override
    public void startSection() {
        this.parse = false;
    }

    @Override
    public void addHandler(Handler handler) {
        this.addDXFTableHandler((DXFTableHandler)handler);
    }

    public void addDXFTableHandler(DXFTableHandler dXFTableHandler) {
        this.handlers.put(dXFTableHandler.getTableKey(), dXFTableHandler);
    }

    @Override
    public void releaseDXFDocument() {
        this.doc = null;
        for (Handler handler : this.handlers.values()) {
            handler.releaseDXFDocument();
        }
    }
}

