/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.table;

import gama.dependencies.kabeja.dxf.DXFViewport;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.table.AbstractTableHandler;

public class DXFVPortTableHandler
extends AbstractTableHandler {
    public static final int GROUPCODE_VPORT_NAME = 2;
    public static final int GROUPCODE_VPORT_LOWER_LEFT_X = 10;
    public static final int GROUPCODE_VPORT_LOWER_LEFT_Y = 20;
    public static final int GROUPCODE_VPORT_UPPER_RIGHT_X = 11;
    public static final int GROUPCODE_VPORT_UPPER_RIGHT_Y = 21;
    public static final int GROUPCODE_VPORT_CENTER_POINT_X = 12;
    public static final int GROUPCODE_VPORT_CENTER_POINT_Y = 22;
    public static final int GROUPCODE_VPORT_SNAP_BASE_POINT_X = 13;
    public static final int GROUPCODE_VPORT_SNAP_BASE_POINT_Y = 23;
    public static final int GROUPCODE_HEIGHT = 40;
    public static final int GROUPCODE_ASPECT_RATIO = 41;
    private DXFViewport viewport;

    @Override
    public void endParsing() {
        this.doc.addDXFViewport(this.viewport);
    }

    @Override
    public String getTableKey() {
        return "VPORT";
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 2: {
                this.viewport.setViewportID(dXFValue.getValue());
                if (!"*active".equals(dXFValue.getValue().toLowerCase())) break;
                this.viewport.setActive(true);
                break;
            }
            case 12: {
                this.viewport.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 22: {
                this.viewport.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 10: {
                this.viewport.getLowerLeftCorner().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.viewport.getLowerLeftCorner().setY(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.viewport.setHeight(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.viewport.setAspectRatio(dXFValue.getDoubleValue());
            }
        }
    }

    @Override
    public void startParsing() {
        this.viewport = new DXFViewport();
    }
}

