/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.webb;

import gama.dependencies.webb.Response;
import gama.dependencies.webb.Webb;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class Request {
    private final Webb webb;
    final Method method;
    final String uri;
    Map<String, Object> params;
    boolean multipleValues;
    Map<String, Object> headers;
    Object payload;
    boolean streamPayload;
    boolean useCaches;
    Integer connectTimeout;
    Integer readTimeout;
    Long ifModifiedSince;
    Boolean followRedirects;
    boolean ensureSuccess;
    boolean compress;
    int retryCount;
    boolean waitExponential;

    Request(Webb webb, Method method, String string) {
        this.webb = webb;
        this.method = method;
        this.uri = string;
        this.followRedirects = webb.followRedirects;
    }

    public String getUri() {
        return this.uri;
    }

    public Request header(String string, Object object) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Object>();
        }
        this.headers.put(string, object);
        return this;
    }

    public Request body(Object object) {
        if (this.method == Method.GET || this.method == Method.DELETE) {
            throw new IllegalStateException("body not allowed for request method " + String.valueOf((Object)this.method));
        }
        this.payload = object;
        this.streamPayload = object instanceof File || object instanceof InputStream;
        return this;
    }

    public Request connectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public Request readTimeout(int n) {
        this.readTimeout = n;
        return this;
    }

    public Request ensureSuccess() {
        this.ensureSuccess = true;
        return this;
    }

    public Request retry(int n, boolean bl) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 10) {
            n2 = 10;
        }
        if (n2 > 3 && !bl) {
            throw new IllegalArgumentException("retries > 3 only valid with wait");
        }
        this.retryCount = n2;
        this.waitExponential = bl;
        return this;
    }

    public Response<InputStream> asStream() {
        return this.webb.execute(this, InputStream.class);
    }

    public Response<Void> asVoid() {
        return this.webb.execute(this, Void.class);
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

