/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.dxf.filter;

import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.ParseException;
import gama.dependencies.kabeja.parser.dxf.filter.DXFStreamEntityFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DXFStreamLayerFilter
extends DXFStreamEntityFilter {
    public static final String PROPERTY_LAYERS_EXCLUDE = "layers.exclude";
    public static final String PROPERTY_LAYERS_INCLUDE = "layers.include";
    public static final int LAYER_NAME = 8;
    protected List<ParseValue> parseValues = new ArrayList<ParseValue>();
    protected Set<String> exclude = new HashSet<String>();
    protected Set<String> include = new HashSet<String>();
    protected String layer = "";
    boolean findLayer = true;

    @Override
    public void setProperties(Map map) {
        StringTokenizer stringTokenizer;
        if (map.containsKey(PROPERTY_LAYERS_INCLUDE)) {
            this.include.clear();
            stringTokenizer = new StringTokenizer((String)map.get(PROPERTY_LAYERS_INCLUDE), "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                this.include.add(string);
            }
        }
        if (map.containsKey(PROPERTY_LAYERS_EXCLUDE)) {
            this.exclude.clear();
            stringTokenizer = new StringTokenizer((String)map.get(PROPERTY_LAYERS_EXCLUDE), "|");
            while (stringTokenizer.hasMoreTokens()) {
                this.exclude.add(stringTokenizer.nextToken());
            }
        }
    }

    @Override
    protected void endEntity() throws ParseException {
        if (this.include.contains(this.layer) || !this.exclude.contains(this.layer)) {
            this.outputEntity();
        }
    }

    protected void outputEntity() throws ParseException {
        Iterator<ParseValue> iterator = this.parseValues.iterator();
        while (iterator.hasNext()) {
            ParseValue parseValue;
            ParseValue parseValue2 = parseValue = iterator.next();
            this.handler.parseGroup(parseValue2.getGroupCode(), parseValue2.getDXFValue());
        }
    }

    @Override
    protected void startEntity(String string) throws ParseException {
        this.parseValues.clear();
        this.findLayer = true;
    }

    @Override
    protected void parseEntity(int n, DXFValue dXFValue) throws ParseException {
        if (this.findLayer && n == 8) {
            this.layer = dXFValue.getValue();
            this.findLayer = false;
        }
        ParseValue parseValue = new ParseValue(n, dXFValue);
        this.parseValues.add(parseValue);
    }

    private static class ParseValue {
        int groupCode;
        DXFValue value;

        public ParseValue(int n, DXFValue dXFValue) {
            this.groupCode = n;
            this.value = dXFValue;
        }

        public int getGroupCode() {
            return this.groupCode;
        }

        public DXFValue getDXFValue() {
            return this.value;
        }
    }
}

