/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEllipse;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFEllipseHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "ELLIPSE";
    public static final int RATIO = 40;
    public static final int START_PARAMETER = 41;
    public static final int END_PARAMTER = 42;
    public static final int COUNTERCLOCKWISE = 73;
    private DXFEllipse ellipse;

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.ellipse;
    }

    @Override
    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.ellipse.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.ellipse.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.ellipse.getCenterPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 11: {
                this.ellipse.getMajorAxisDirection().setX(dXFValue.getDoubleValue());
                break;
            }
            case 21: {
                this.ellipse.getMajorAxisDirection().setY(dXFValue.getDoubleValue());
                break;
            }
            case 31: {
                this.ellipse.getMajorAxisDirection().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.ellipse.setRatio(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.ellipse.setStartParameter(dXFValue.getDoubleValue());
                break;
            }
            case 42: {
                this.ellipse.setEndParameter(dXFValue.getDoubleValue());
                break;
            }
            case 73: {
                this.ellipse.setCounterClockwise(dXFValue.getBooleanValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.ellipse);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.ellipse = new DXFEllipse();
        this.ellipse.setDXFDocument(this.doc);
    }
}

