/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing;

import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.processing.PostProcessorConfig;
import gama.dependencies.kabeja.processing.ProcessingManager;
import gama.dependencies.kabeja.processing.ProcessorException;
import gama.dependencies.kabeja.processing.helper.MergeMap;
import gama.dependencies.kabeja.tools.SAXFilterConfig;
import gama.dependencies.kabeja.xml.SAXGenerator;
import gama.dependencies.kabeja.xml.SAXSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProcessPipeline {
    private ProcessingManager manager;
    private final List<PostProcessorConfig> postProcessorConfigs = new ArrayList<PostProcessorConfig>();
    private final List<SAXFilterConfig> saxFilterConfigs = new ArrayList<SAXFilterConfig>();
    private SAXGenerator generator;
    private Map serializerProperties = new HashMap();
    private Map generatorProperties = new HashMap();
    private SAXSerializer serializer;
    private String name;
    private String description = "";

    public void process(DXFDocument dXFDocument, Map map, OutputStream outputStream) throws ProcessorException {
        Object object;
        Object sAXException;
        Object object2;
        Object object5 = null;
        for (PostProcessorConfig object42 : this.postProcessorConfigs) {
            object2 = this.manager.getPostProcessor(object42.getPostProcessorName());
            sAXException = object2.getProperties();
            object2.setProperties(new MergeMap(object42.getProperties(), map));
            object2.process(dXFDocument, map);
            object2.setProperties((Map)sAXException);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        if (this.saxFilterConfigs.size() > 0) {
            Iterator<Object> iterator = this.saxFilterConfigs.iterator();
            object2 = (SAXFilterConfig)iterator.next();
            sAXException = this.manager.getSAXFilter(((SAXFilterConfig)object2).getFilterName());
            arrayList.add(new MergeMap(sAXException.getProperties(), map));
            sAXException.setContentHandler(this.serializer);
            object5 = sAXException;
            sAXException.setProperties(((SAXFilterConfig)object2).getProperties());
            while (iterator.hasNext()) {
                object2 = (SAXFilterConfig)iterator.next();
                object = this.manager.getSAXFilter(((SAXFilterConfig)object2).getFilterName());
                object.setContentHandler((ContentHandler)sAXException);
                arrayList.add(object.getProperties());
                object.setProperties(((SAXFilterConfig)object2).getProperties());
                sAXException = object;
            }
        } else {
            object5 = this.serializer;
        }
        object2 = this.serializer.getProperties();
        this.serializer.setProperties(new MergeMap(this.serializerProperties, map));
        this.serializer.setOutput(outputStream);
        try {
            sAXException = this.generator.getProperties();
            this.generator.setProperties(this.generatorProperties);
            this.generator.generate(dXFDocument, (ContentHandler)object5, map);
            this.generator.setProperties((Map)sAXException);
        }
        catch (SAXException n) {
            throw new ProcessorException(n);
        }
        this.serializer.setProperties((Map)object2);
        int n = 0;
        while (n < arrayList.size()) {
            object = this.saxFilterConfigs.get(n);
            this.manager.getSAXFilter(((SAXFilterConfig)object).getFilterName()).setProperties((Map)arrayList.get(n));
            ++n;
        }
    }

    public SAXSerializer getSAXSerializer() {
        return this.serializer;
    }

    public void setSAXSerializer(SAXSerializer sAXSerializer) {
        this.serializer = sAXSerializer;
    }

    public ProcessingManager getProcessorManager() {
        return this.manager;
    }

    public void setProcessorManager(ProcessingManager processingManager) {
        this.manager = processingManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void prepare() {
    }

    public List getPostProcessorConfigs() {
        return this.postProcessorConfigs;
    }

    public void addSAXFilterConfig(SAXFilterConfig sAXFilterConfig) {
        this.saxFilterConfigs.add(sAXFilterConfig);
    }

    public void addPostProcessorConfig(PostProcessorConfig postProcessorConfig) {
        this.postProcessorConfigs.add(postProcessorConfig);
    }

    public Map getSerializerProperties() {
        return this.serializerProperties;
    }

    public void setSAXSerializerProperties(Map map) {
        this.serializerProperties = map;
    }

    public void setSAXGeneratorProperties(Map map) {
        this.generatorProperties = map;
    }

    public Map getSAXGeneratorProperties(Map map) {
        return this.generatorProperties;
    }

    public void setSAXGenerator(SAXGenerator sAXGenerator) {
        this.generator = sAXGenerator;
    }

    public SAXGenerator getSAXGenerator() {
        return this.generator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

