/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.TimestampContainer;
import gama.dependencies.osmosis.TimestampFormat;
import java.util.Date;

public class UnparsedTimestampContainer
implements TimestampContainer {
    private final TimestampFormat managedTimestampFormat;
    private final String timestampString;
    private Date timestamp;

    public UnparsedTimestampContainer(TimestampFormat timestampFormat, String string) {
        this.managedTimestampFormat = timestampFormat;
        this.timestampString = string;
        if (string == null) {
            throw new OsmosisRuntimeException("The entity timestamp attribute is missing.");
        }
    }

    @Override
    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        if (this.timestampString != null && this.managedTimestampFormat.isEquivalent(timestampFormat)) {
            return this.timestampString;
        }
        this.getTimestamp();
        if (this.timestamp != null) {
            return timestampFormat.formatTimestamp(this.timestamp);
        }
        return "";
    }

    @Override
    public Date getTimestamp() {
        if (this.timestamp == null && this.timestampString != null && this.timestampString.length() > 0) {
            this.timestamp = this.managedTimestampFormat.parseTimestamp(this.timestampString);
        }
        return this.timestamp;
    }
}

