/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.EntityElementProcessor;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.TagElementProcessor;
import gama.dependencies.osmosis.TagListener;
import gama.dependencies.osmosis.TimestampContainer;
import gama.dependencies.osmosis.Way;
import gama.dependencies.osmosis.WayContainer;
import gama.dependencies.osmosis.WayNode;
import gama.dependencies.osmosis.WayNodeElementProcessor;
import gama.dependencies.osmosis.WayNodeListener;
import org.xml.sax.Attributes;

public class WayElementProcessor
extends EntityElementProcessor
implements TagListener,
WayNodeListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NODE = "nd";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private final TagElementProcessor tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    private final WayNodeElementProcessor wayNodeElementProcessor = new WayNodeElementProcessor((BaseElementProcessor)this, this);
    private Way way;

    public WayElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl) {
        super(baseElementProcessor, sink, bl);
    }

    @Override
    public void begin(Attributes attributes) {
        long l = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String string = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (string == null) {
            throw new OsmosisRuntimeException("Way " + l + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int n = Integer.parseInt(string);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String string2 = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String string3 = attributes.getValue(ATTRIBUTE_NAME_USER);
        long l2 = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        OsmUser osmUser = this.buildUser(string2, string3);
        this.way = new Way(new CommonEntityData(l, n, timestampContainer, osmUser, l2));
    }

    @Override
    public ElementProcessor getChild(String string, String string2, String string3) {
        if (ELEMENT_NAME_NODE.equals(string3)) {
            return this.wayNodeElementProcessor;
        }
        if (ELEMENT_NAME_TAG.equals(string3)) {
            return this.tagElementProcessor;
        }
        return super.getChild(string, string2, string3);
    }

    @Override
    public void end() {
        this.getSink().process(new WayContainer(this.way));
    }

    @Override
    public void processTag(Tag tag) {
        this.way.getTags().add(tag);
    }

    @Override
    public void processWayNode(WayNode wayNode) {
        this.way.getWayNodes().add(wayNode);
    }
}

