/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.helpers.ParametricLine;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;

public class HatchLineSegment {
    protected Point startPoint;
    protected Vector direction;
    protected double angle;
    protected double totalLength;
    protected double length;
    protected double currentLength;
    protected double[] pattern;
    protected double l;
    protected int index;
    protected ParametricLine line;

    public HatchLineSegment(Point point, double d, double d2) {
        this.startPoint = point;
        this.angle = Math.toRadians(d);
        this.totalLength = d2;
    }

    public HatchLineSegment(Point point, Vector vector, double d) {
        this.startPoint = point;
        this.direction = vector;
        this.totalLength = d;
    }

    public HatchLineSegment(ParametricLine parametricLine, double d, double d2, double[] dArray) {
        this.startPoint = parametricLine.getStartPoint();
        this.totalLength = d;
        this.currentLength = d2;
        this.pattern = dArray;
        this.line = parametricLine;
        this.initialize(d2);
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public double getLength() {
        return this.totalLength;
    }

    public Point getPoint(double d) {
        Point point = new Point();
        point.setX(this.startPoint.getX() + Math.cos(this.angle) * this.totalLength);
        point.setY(this.startPoint.getY() + Math.sin(this.angle) * this.totalLength);
        return point;
    }

    public Point getPointAt(double d) {
        return this.line.getPointAt(d);
    }

    public boolean hasNext() {
        return this.length <= this.totalLength;
    }

    public double next() {
        double d = this.currentLength;
        this.length += Math.abs(this.currentLength);
        if (this.index == this.pattern.length) {
            this.index = 0;
        }
        this.currentLength = this.pattern[this.index];
        ++this.index;
        return d;
    }

    protected void initialize(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.pattern.length) {
            if ((d2 += Math.abs(this.pattern[n])) > d) {
                this.currentLength = d2 - d;
                if (this.pattern[n] < 0.0) {
                    this.currentLength *= -1.0;
                }
                this.index = n + 1;
                return;
            }
            ++n;
        }
    }

    public boolean isSolid() {
        return this.pattern.length == 0;
    }
}

