/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser;

import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.parser.DXFSectionHandler;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.Handler;
import gama.dependencies.kabeja.parser.HandlerManager;
import gama.dependencies.kabeja.parser.ParseException;
import gama.dependencies.kabeja.parser.Parser;
import gama.dependencies.kabeja.parser.dxf.DXFHandler;
import gama.dependencies.kabeja.parser.dxf.filter.DXFStreamFilter;
import gama.dependencies.kabeja.tools.CodePageParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DXFParser
implements HandlerManager,
Handler,
Parser,
DXFHandler {
    public static final String PARSER_NAME = "DXFParser";
    public static final String EXTENSION = "dxf";
    private static final String SECTION_START = "SECTION";
    private static final String SECTION_END = "ENDSEC";
    private static final String END_STREAM = "EOF";
    private static final int COMMAND_CODE = 0;
    public static final String DEFAULT_ENCODING = "";
    protected DXFDocument doc;
    protected Hashtable<String, DXFSectionHandler> handlers = new Hashtable();
    protected DXFSectionHandler currentHandler;
    private String line;
    protected List<DXFStreamFilter> streamFilters = new ArrayList<DXFStreamFilter>();
    protected DXFHandler filter;
    private boolean key = false;
    private boolean sectionstarts = false;
    private int linecount;
    private boolean parse = false;

    @Override
    public void parse(String string) throws ParseException {
        this.parse(string, DEFAULT_ENCODING);
    }

    @Override
    public void parse(String string, String string2) throws ParseException {
        try {
            this.parse(new FileInputStream(string), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public void parse(InputStream inputStream, String string) throws ParseException {
        String string2 = DEFAULT_ENCODING;
        this.key = false;
        this.linecount = 0;
        this.parse = false;
        this.doc = new DXFDocument();
        this.doc.setProperty(DXFDocument.PROPERTY_ENCODING, string);
        this.buildFilterChain();
        BufferedReader bufferedReader = null;
        try {
            if (DEFAULT_ENCODING.equals(string)) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(9000);
                try {
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(bufferedInputStream));
                    CodePageParser codePageParser = new CodePageParser();
                    string = codePageParser.parseEncoding(bufferedReader2);
                    bufferedInputStream.reset();
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string));
                }
                catch (IOException iOException) {
                    bufferedInputStream.reset();
                    bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                }
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            }
            this.key = true;
            this.sectionstarts = false;
            while ((this.line = bufferedReader.readLine()) != null) {
                ++this.linecount;
                if (this.key) {
                    string2 = this.line;
                    this.key = false;
                    continue;
                }
                int n = Integer.parseInt(string2.trim());
                this.filter.parseGroup(n, new DXFValue(this.line.trim()));
                this.key = true;
            }
            bufferedReader.close();
            bufferedReader = null;
            if (this.parse) {
                this.currentHandler.endSection();
            }
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) throws ParseException {
        try {
            if (this.sectionstarts) {
                this.sectionstarts = false;
                if (this.handlers.containsKey(dXFValue.getValue())) {
                    this.currentHandler = this.handlers.get(dXFValue.getValue());
                    this.parse = true;
                    this.currentHandler.setDXFDocument(this.doc);
                    this.currentHandler.startSection();
                } else {
                    this.parse = false;
                }
                return;
            }
            if (n == 0 && SECTION_START.equals(dXFValue.getValue()) && !this.sectionstarts) {
                this.sectionstarts = true;
            }
            if (n == 0 && SECTION_END.equals(dXFValue.getValue())) {
                if (this.parse) {
                    this.currentHandler.endSection();
                }
                this.parse = false;
                return;
            }
            if (this.parse) {
                this.currentHandler.parseGroup(n, dXFValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new ParseException("Line: " + this.linecount + " unsupported groupcode: " + this.key + " for value:" + String.valueOf(dXFValue), numberFormatException);
        }
    }

    @Override
    public DXFDocument getDocument() {
        return this.doc;
    }

    public void addDXFSectionHandler(DXFSectionHandler dXFSectionHandler) {
        dXFSectionHandler.setDXFDocument(this.doc);
        this.handlers.put(dXFSectionHandler.getSectionKey(), dXFSectionHandler);
    }

    @Override
    public void addHandler(Handler handler) {
        this.addDXFSectionHandler((DXFSectionHandler)handler);
    }

    @Override
    public void releaseDXFDocument() {
        this.doc = null;
        for (Handler handler : this.handlers.values()) {
            handler.releaseDXFDocument();
        }
    }

    @Override
    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
    }

    @Override
    public boolean supportedExtension(String string) {
        return EXTENSION.equals(string.toLowerCase());
    }

    public void addDXFStreamFilter(DXFStreamFilter dXFStreamFilter) {
        this.streamFilters.add(dXFStreamFilter);
    }

    public void removeDXFStreamFilter(DXFStreamFilter dXFStreamFilter) {
        this.streamFilters.remove(dXFStreamFilter);
    }

    protected void buildFilterChain() {
        DXFHandler dXFHandler = this;
        int n = this.streamFilters.size() - 1;
        while (n >= 0) {
            DXFStreamFilter dXFStreamFilter = this.streamFilters.get(n);
            dXFStreamFilter.setDXFHandler(dXFHandler);
            dXFHandler = dXFStreamFilter;
            --n;
        }
        this.filter = dXFHandler;
    }

    @Override
    public String getName() {
        return PARSER_NAME;
    }
}

