/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.table;

import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.table.AbstractTableHandler;

public class DXFLayerTableHandler
extends AbstractTableHandler {
    public static final String TABLE_KEY = "LAYER";
    public static final int GROUPCODE_LAYER_NAME = 2;
    public static final int GROUPCODE_LAYER_LINETYPE = 6;
    public static final int GROUPCODE_LAYER_COLORNUMBER = 62;
    public static final int GROUPCODE_LAYER_PLOTTINGFLAG = 290;
    public static final int GROUPCODE_LAYER_LINEWEIGHT = 370;
    public static final int GROUPCODE_LAYER_PLOTSTYLENAME = 390;
    private DXFLayer layer;

    @Override
    public String getTableKey() {
        return TABLE_KEY;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 2: {
                this.layer.setName(dXFValue.getValue());
                break;
            }
            case 62: {
                this.layer.setColor(dXFValue.getIntegerValue());
                break;
            }
            case 6: {
                this.layer.setLineType(dXFValue.getValue());
                break;
            }
            case 70: {
                this.layer.setFlags(dXFValue.getIntegerValue());
                break;
            }
            case 370: {
                this.layer.setLineWeight(dXFValue.getIntegerValue());
                break;
            }
            case 390: {
                this.layer.setPlotStyle(dXFValue.getValue());
            }
        }
    }

    @Override
    public void endParsing() {
        this.doc.addDXFLayer(this.layer);
    }

    @Override
    public void startParsing() {
        this.layer = new DXFLayer();
        this.layer.setDXFDocument(this.doc);
    }
}

