/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.table;

import gama.dependencies.kabeja.dxf.DXFView;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.table.AbstractTableHandler;

public class DXFViewTableHandler
extends AbstractTableHandler {
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_CENTER_X = 10;
    public static final int GROUPCODE_CENTER_Y = 20;
    public static final int GROUPCODE_CENTER_Z = 30;
    public static final int GROUPCODE_HEIGHT = 40;
    public static final int GROUPCODE_WIDTH = 41;
    public static final int GROUPCODE_VIEW_DIRECTION_X = 11;
    public static final int GROUPCODE_VIEW_DIRECTION_Y = 21;
    public static final int GROUPCODE_VIEW_DIRECTION_Z = 31;
    public static final int GROUPCODE_VIEW_TARGET_X = 12;
    public static final int GROUPCODE_VIEW_TARGET_Y = 22;
    public static final int GROUPCODE_VIEW_TARGET_Z = 32;
    public static final int GROUPCODE_LENS_LENGTH = 42;
    public static final int GROUPCODE_FRONT_CLIPPING = 43;
    public static final int GROUPCODE_BACK_CLIPPING = 44;
    public static final int GROUPCODE_TWIST_ANGLE = 50;
    public static final int GROUPCODE_RENDER_MODE = 281;
    public static final int GROUPCODE_UCS_ORIGIN_X = 110;
    public static final int GROUPCODE_UCS_ORIGIN_Y = 120;
    public static final int GROUPCODE_UCS_ORIGIN_Z = 130;
    public static final int GROUPCODE_UCS_X_AXIS_X = 111;
    public static final int GROUPCODE_UCS_X_AXIS_Y = 121;
    public static final int GROUPCODE_UCS_X_AXIS_Z = 131;
    public static final int GROUPCODE_UCS_Y_AXIS_X = 112;
    public static final int GROUPCODE_UCS_Y_AXIS_Y = 122;
    public static final int GROUPCODE_UCS_Y_AXIS_Z = 132;
    public static final int GROUPCODE_UCS_TYPE = 79;
    public static final int GROUPCODE_UCS_ELEVATION = 146;
    public static final int GROUPCODE_USE_UCS = 72;
    private DXFView view;

    @Override
    public void endParsing() {
        this.doc.addDXFView(this.view);
    }

    @Override
    public String getTableKey() {
        return "VIEW";
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.view.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.view.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.view.getCenterPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 2: {
                this.view.setName(dXFValue.getValue());
                break;
            }
            case 41: {
                this.view.setWidth(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.view.setHeight(dXFValue.getDoubleValue());
                break;
            }
            case 43: {
                this.view.setFrontClipping(dXFValue.getDoubleValue());
                break;
            }
            case 44: {
                this.view.setBackClipping(dXFValue.getDoubleValue());
                break;
            }
            case 42: {
                this.view.setLensLength(dXFValue.getDoubleValue());
                break;
            }
            case 281: {
                this.view.setRenderMode(dXFValue.getIntegerValue());
                break;
            }
            case 50: {
                this.view.setTwistAngle(dXFValue.getDoubleValue());
                break;
            }
            case 72: {
                this.view.setUseUCS(dXFValue.getBooleanValue());
                break;
            }
            case 146: {
                this.view.setUcsElevation(dXFValue.getDoubleValue());
                break;
            }
            case 110: {
                this.view.getUcsOrigin().setX(dXFValue.getDoubleValue());
                break;
            }
            case 120: {
                this.view.getUcsOrigin().setY(dXFValue.getDoubleValue());
                break;
            }
            case 130: {
                this.view.getUcsOrigin().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 111: {
                this.view.getUcsXAxis().setX(dXFValue.getDoubleValue());
                break;
            }
            case 121: {
                this.view.getUcsXAxis().setY(dXFValue.getDoubleValue());
                break;
            }
            case 131: {
                this.view.getUcsXAxis().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 112: {
                this.view.getUcsYAxis().setX(dXFValue.getDoubleValue());
                break;
            }
            case 122: {
                this.view.getUcsYAxis().setY(dXFValue.getDoubleValue());
                break;
            }
            case 132: {
                this.view.getUcsYAxis().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 79: {
                this.view.setUcsType(dXFValue.getIntegerValue());
            }
        }
    }

    @Override
    public void startParsing() {
        this.view = new DXFView();
    }
}

