/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.OsmElementProcessor;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Sink;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(OsmHandler.class.getName());
    private static final String ELEMENT_NAME_OSM = "osm";
    private final ElementProcessor osmElementProcessor;
    private ElementProcessor elementProcessor;
    private Locator documentLocator;

    public OsmHandler(Sink sink, boolean bl) {
        this.osmElementProcessor = new OsmElementProcessor(null, sink, bl, true);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.elementProcessor != null) {
            this.elementProcessor = this.elementProcessor.getChild(string, string2, string3);
        } else if (ELEMENT_NAME_OSM.equals(string3)) {
            this.elementProcessor = this.osmElementProcessor;
        } else {
            throw new OsmosisRuntimeException("This does not appear to be an OSM XML file.");
        }
        this.elementProcessor.begin(attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.elementProcessor.end();
        this.elementProcessor = this.elementProcessor.getParent();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        LOG.severe("Unable to parse xml file.  publicId=(" + this.documentLocator.getPublicId() + "), systemId=(" + this.documentLocator.getSystemId() + "), lineNumber=" + this.documentLocator.getLineNumber() + ", columnNumber=" + this.documentLocator.getColumnNumber() + ".");
        super.error(sAXParseException);
    }
}

