/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.DXFConstants;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;
import gama.dependencies.kabeja.math.MathUtils;

public class DXFExtrusion {
    private static final double v = 0.015625;
    protected Vector n = new Vector(0.0, 0.0, 1.0);
    protected Vector x;
    protected Vector y;

    public double getX() {
        return this.n.getX();
    }

    public void setX(double d) {
        this.n.setX(d);
    }

    public double getY() {
        return this.n.getY();
    }

    public void setY(double d) {
        this.n.setY(d);
    }

    public double getZ() {
        return this.n.getZ();
    }

    public void setZ(double d) {
        this.n.setZ(d);
    }

    public Vector getDirectionX() {
        if (Math.abs(this.n.getX()) < 0.015625 && Math.abs(this.n.getY()) < 0.015625) {
            return MathUtils.crossProduct(DXFConstants.DEFAULT_Y_AXIS_VECTOR, this.n);
        }
        return MathUtils.crossProduct(DXFConstants.DEFAULT_Z_AXIS_VECTOR, this.n);
    }

    public Vector getDirectionY() {
        return MathUtils.crossProduct(this.n, this.getDirectionX());
    }

    public Point extrudePoint(Point point, double d) {
        return MathUtils.getPointOfStraightLine(point, this.n, d);
    }

    public Vector getNormal() {
        return this.n;
    }

    public Vector getDirectionZ() {
        return this.n;
    }
}

