/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing;

import gama.dependencies.kabeja.dxf.DXFArc;
import gama.dependencies.kabeja.dxf.DXFConstants;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.dxf.DXFLine;
import gama.dependencies.kabeja.dxf.DXFPolyline;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.processing.AbstractPostProcessor;
import gama.dependencies.kabeja.processing.ProcessorException;
import gama.dependencies.kabeja.processing.helper.PolylineQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PolylineConverter
extends AbstractPostProcessor {
    public static final String PROPERTY_POINT_DISTANCE = "point.distance";
    private List<PolylineQueue> queues;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    @Override
    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        Iterator iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer = (DXFLayer)iterator.next();
            this.processLayer(dXFLayer);
        }
    }

    @Override
    public void setProperties(Map map) {
        if (map.containsKey(PROPERTY_POINT_DISTANCE)) {
            this.radius = Double.parseDouble((String)map.get(PROPERTY_POINT_DISTANCE));
        }
    }

    protected void processLayer(DXFLayer dXFLayer) {
        Point point;
        Point point2;
        List<DXFEntity> list;
        this.queues = new ArrayList<PolylineQueue>();
        if (dXFLayer.hasDXFEntities("LINE")) {
            list = dXFLayer.getDXFEntities("LINE");
            for (DXFEntity dXFEntity : list) {
                point2 = ((DXFLine)dXFEntity).getStartPoint();
                point = ((DXFLine)dXFEntity).getEndPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("POLYLINE")) {
            list = dXFLayer.getDXFEntities("POLYLINE");
            for (DXFEntity dXFEntity : list) {
                if (((DXFPolyline)dXFEntity).isClosed() || ((DXFPolyline)dXFEntity).is3DPolygonMesh() || ((DXFPolyline)dXFEntity).isClosedMeshMDirection() || ((DXFPolyline)dXFEntity).isClosedMeshNDirection() || ((DXFPolyline)dXFEntity).isCubicSurefaceMesh()) continue;
                point2 = ((DXFPolyline)dXFEntity).getVertex(0).getPoint();
                point = ((DXFPolyline)dXFEntity).getVertex(((DXFPolyline)dXFEntity).getVertexCount() - 1).getPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("LWPOLYLINE")) {
            list = dXFLayer.getDXFEntities("LWPOLYLINE");
            for (DXFEntity dXFEntity : list) {
                if (((DXFPolyline)dXFEntity).isClosed() || ((DXFPolyline)dXFEntity).is3DPolygonMesh() || ((DXFPolyline)dXFEntity).isClosedMeshMDirection() || ((DXFPolyline)dXFEntity).isClosedMeshNDirection() || ((DXFPolyline)dXFEntity).isCubicSurefaceMesh()) continue;
                point2 = ((DXFPolyline)dXFEntity).getVertex(0).getPoint();
                point = ((DXFPolyline)dXFEntity).getVertex(((DXFPolyline)dXFEntity).getVertexCount() - 1).getPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("ARC")) {
            list = dXFLayer.getDXFEntities("ARC");
            for (DXFEntity dXFEntity : list) {
                point2 = ((DXFArc)dXFEntity).getStartPoint();
                point = ((DXFArc)dXFEntity).getEndPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        this.connectPolylineQueues();
        this.cleanUp(dXFLayer);
    }

    protected void checkDXFEntity(DXFEntity dXFEntity, Point point, Point point2) {
        PolylineQueue polylineQueue2;
        for (PolylineQueue polylineQueue2 : this.queues) {
            if (!polylineQueue2.connectDXFEntity(dXFEntity, point, point2)) continue;
            return;
        }
        polylineQueue2 = new PolylineQueue(dXFEntity, point, point2, this.radius);
        this.queues.add(polylineQueue2);
    }

    protected void cleanUp(DXFLayer dXFLayer) {
        Iterator<PolylineQueue> iterator = this.queues.iterator();
        while (iterator.hasNext()) {
            PolylineQueue polylineQueue = iterator.next();
            if (polylineQueue.size() > 1) {
                polylineQueue.createDXFPolyline(dXFLayer);
                continue;
            }
            iterator.remove();
        }
    }

    protected void connectPolylineQueues() {
        int n = 0;
        while (n < this.queues.size()) {
            PolylineQueue polylineQueue = this.queues.get(n);
            boolean bl = false;
            int n2 = n + 1;
            while (n2 < this.queues.size() && !bl) {
                if (this.queues.get(n2).connect(polylineQueue)) {
                    this.queues.remove(n);
                    --n;
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
    }
}

