/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CompressFlags;
import gama.dependencies.osmosis.FileBlock;
import gama.dependencies.osmosis.FileBlockPosition;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BlockOutputStream {
    OutputStream outwrite;
    List<FileBlockPosition> writtenblocks = new ArrayList<FileBlockPosition>();
    CompressFlags compression;

    public BlockOutputStream(OutputStream outputStream) {
        this.outwrite = new DataOutputStream(outputStream);
        this.compression = CompressFlags.DEFLATE;
    }

    public void setCompress(CompressFlags compressFlags) {
        this.compression = compressFlags;
    }

    public void setCompress(String string) {
        if (string.equals("none")) {
            this.compression = CompressFlags.NONE;
        } else if (string.equals("deflate")) {
            this.compression = CompressFlags.DEFLATE;
        } else {
            throw new Error("Unknown compression type: " + string);
        }
    }

    public void write(FileBlock fileBlock) throws IOException {
        this.write(fileBlock, this.compression);
    }

    public void write(FileBlock fileBlock, CompressFlags compressFlags) throws IOException {
        FileBlockPosition fileBlockPosition = fileBlock.writeTo(this.outwrite, compressFlags);
        this.writtenblocks.add(fileBlockPosition);
    }

    public void flush() throws IOException {
        this.outwrite.flush();
    }

    public void close() throws IOException {
        this.outwrite.flush();
        this.outwrite.close();
    }
}

