/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.WayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Way
extends Entity
implements Comparable<Way> {
    private List<WayNode> wayNodes;

    public Way(CommonEntityData commonEntityData) {
        super(commonEntityData);
        this.wayNodes = new ArrayList<WayNode>();
    }

    public Way(CommonEntityData commonEntityData, List<WayNode> list) {
        super(commonEntityData);
        this.wayNodes = new ArrayList<WayNode>(list);
    }

    private Way(Way way) {
        super(way);
        this.wayNodes = new ArrayList<WayNode>(way.wayNodes);
    }

    public Way(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        super(storeReader, storeClassRegister);
        int n = storeReader.readInteger();
        this.wayNodes = new ArrayList<WayNode>();
        int n2 = 0;
        while (n2 < n) {
            this.wayNodes.add(new WayNode(storeReader, storeClassRegister));
            ++n2;
        }
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        super.store(storeWriter, storeClassRegister);
        storeWriter.writeInteger(this.wayNodes.size());
        for (WayNode wayNode : this.wayNodes) {
            wayNode.store(storeWriter, storeClassRegister);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.Way;
    }

    public boolean equals(Object object) {
        if (object instanceof Way) {
            return this.compareTo((Way)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    protected int compareWayNodes(List<WayNode> list) {
        if (this.wayNodes.size() != list.size()) {
            return this.wayNodes.size() - list.size();
        }
        Iterator<WayNode> iterator = this.wayNodes.iterator();
        Iterator<WayNode> iterator2 = list.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next().compareTo(iterator2.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int compareTo(Way way) {
        int n;
        if (this.getId() < way.getId()) {
            return -1;
        }
        if (this.getId() > way.getId()) {
            return 1;
        }
        if (this.getVersion() < way.getVersion()) {
            return -1;
        }
        if (this.getVersion() > way.getVersion()) {
            return 1;
        }
        if (this.getTimestamp() == null && way.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && way.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && way.getTimestamp() != null && (n = this.getTimestamp().compareTo(way.getTimestamp())) != 0) {
            return n;
        }
        int n2 = this.compareWayNodes(way.getWayNodes());
        if (n2 != 0) {
            return n2;
        }
        return this.compareTags(way.getTags());
    }

    @Override
    public void makeReadOnly() {
        if (!this.isReadOnly()) {
            this.wayNodes = Collections.unmodifiableList(this.wayNodes);
        }
        super.makeReadOnly();
    }

    public List<WayNode> getWayNodes() {
        return this.wayNodes;
    }

    @Override
    public Way getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Way(this);
        }
        return this;
    }

    public boolean isClosed() {
        return this.wayNodes.get(0).getNodeId() == this.wayNodes.get(this.wayNodes.size() - 1).getNodeId();
    }

    public String toString() {
        String string = null;
        Collection<Tag> collection = this.getTags();
        for (Tag tag : collection) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("name")) continue;
            string = tag.getValue();
            break;
        }
        if (string != null) {
            return "Way(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", name='" + string + "')";
        }
        return "Way(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

