/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFCircle;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFCircleHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "CIRCLE";
    public static final int RADIUS = 40;
    private DXFCircle circle;

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.circle;
    }

    @Override
    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.circle.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.circle.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.circle.setRadius(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.circle);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.circle = new DXFCircle();
        this.circle.setCenterPoint(new Point());
        this.circle.setDXFDocument(this.doc);
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }
}

