/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFMText;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFMTextHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "MTEXT";
    public static final int TEXT_VALUE_END = 1;
    public static final int TEXT_VALUE = 3;
    public static final int TEXT_HEIGHT = 40;
    public static final int TEXT_REF_WIDTH = 41;
    public static final int TEXT_REF_HEIGHT = 43;
    public static final int TEXT_DRAWING_DIRECTION_FLAG = 72;
    public static final int TEXT_ATTACHMENT_POINT = 71;
    public static final int TEXT_VALIGN = 73;
    public static final int TEXT_ALIGN_X = 11;
    public static final int TEXT_ALIGN_Y = 21;
    public static final int TEXT_ALIGN_Z = 31;
    public static final int TEXT_STYLE = 7;
    public static final int TEXT_OBLIQUEANGLE = 51;
    public static final int TEXT_ROTATION = 50;
    private DXFMText mtext;
    private StringBuffer buf = new StringBuffer();
    private int insert = 0;

    @Override
    public void endDXFEntity() {
        this.mtext.setText(this.buf.toString());
        this.buf.delete(0, this.buf.length());
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.mtext;
    }

    @Override
    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 3: {
                String string = dXFValue.getValue();
                this.buf.insert(this.insert, string);
                this.insert += string.length();
                break;
            }
            case 1: {
                this.buf.insert(this.insert, dXFValue.getValue());
                break;
            }
            case 71: {
                this.mtext.setAttachmentPoint(dXFValue.getIntegerValue());
                break;
            }
            case 10: {
                this.mtext.setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.mtext.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.mtext.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 11: {
                this.mtext.setAlignX(dXFValue.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 21: {
                this.mtext.setAlignY(dXFValue.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 31: {
                this.mtext.setAlignZ(dXFValue.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 40: {
                this.mtext.setHeight(dXFValue.getDoubleValue());
                break;
            }
            case 72: {
                switch (dXFValue.getIntegerValue()) {
                    case 2: {
                        this.mtext.setBackward(true);
                        break;
                    }
                    case 4: {
                        this.mtext.setUpsideDown(true);
                    }
                }
                break;
            }
            case 7: {
                this.mtext.setTextStyle(dXFValue.getValue());
                break;
            }
            case 50: {
                this.mtext.setRotation(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.mtext.setReferenceWidth(dXFValue.getDoubleValue());
                break;
            }
            case 43: {
                this.mtext.setReferenceHeight(dXFValue.getDoubleValue());
                break;
            }
            case 51: {
                this.mtext.setObliqueAngle(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.mtext);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.mtext = new DXFMText();
        this.insert = 0;
    }
}

