/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.processing.AbstractPostProcessor;
import gama.dependencies.kabeja.processing.ProcessorException;
import java.util.Iterator;
import java.util.Map;

public class BoundsFilter
extends AbstractPostProcessor {
    public static final String PROPERTY_X = "boundsfilter.x";
    public static final String PROPERTY_Y = "boundsfilter.y";
    public static final String PROPERTY_WIDTH = "boundsfilter.width";
    public static final String PROPERTY_HEIGHT = "boundsfilter.height";
    public static final String PROPERTY_PROCESS = "boundsfilter.process";

    @Override
    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        if (this.properties.containsKey(PROPERTY_PROCESS) && Boolean.valueOf((String)this.properties.get(PROPERTY_PROCESS)).booleanValue()) {
            Bounds bounds = new Bounds();
            if (this.properties.containsKey(PROPERTY_X)) {
                bounds.setMinimumX(Double.parseDouble((String)this.properties.get(PROPERTY_X)));
            }
            if (this.properties.containsKey(PROPERTY_Y)) {
                bounds.setMinimumY(Double.parseDouble((String)this.properties.get(PROPERTY_Y)));
            }
            if (this.properties.containsKey(PROPERTY_WIDTH)) {
                bounds.setMaximumX(bounds.getMinimumX() + Double.parseDouble((String)this.properties.get(PROPERTY_WIDTH)));
            }
            if (this.properties.containsKey(PROPERTY_WIDTH)) {
                bounds.setMaximumY(bounds.getMinimumY() + Double.parseDouble((String)this.properties.get(PROPERTY_HEIGHT)));
            }
            Iterator iterator = dXFDocument.getDXFLayerIterator();
            while (iterator.hasNext()) {
                DXFLayer dXFLayer = (DXFLayer)iterator.next();
                this.filterLayer(dXFLayer, bounds);
            }
        }
    }

    protected void filterLayer(DXFLayer dXFLayer, Bounds bounds) {
        Iterator<String> iterator = dXFLayer.getDXFEntityTypeIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Iterator<DXFEntity> iterator2 = dXFLayer.getDXFEntities(string).iterator();
            while (iterator2.hasNext()) {
                DXFEntity dXFEntity = iterator2.next();
                if (bounds.enclose(dXFEntity.getBounds())) continue;
                iterator2.remove();
            }
        }
    }
}

