/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.dxf.filter;

import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.ParseException;
import gama.dependencies.kabeja.parser.dxf.filter.AbstractDXFStreamFilter;

abstract class DXFStreamSectionFilter
extends AbstractDXFStreamFilter {
    private static final String SECTION_START = "SECTION";
    private static final String SECTION_END = "ENDSEC";
    private static final int COMMAND_CODE = 0;
    protected boolean sectionStarts = false;
    protected String section;

    DXFStreamSectionFilter() {
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) throws ParseException {
        if (n == 0 && SECTION_START.equals(dXFValue.getValue())) {
            this.sectionStarts = true;
        } else if (this.sectionStarts) {
            this.sectionStarts = false;
            this.section = dXFValue.getValue();
            this.sectionStart(this.section);
            this.parseSection(0, new DXFValue(SECTION_START));
            this.parseSection(n, dXFValue);
        } else {
            this.parseSection(n, dXFValue);
        }
        if (n == 0 && SECTION_END.equals(dXFValue.getValue())) {
            this.sectionEnd(this.section);
        }
    }

    protected abstract void parseSection(int var1, DXFValue var2) throws ParseException;

    protected abstract void sectionStart(String var1) throws ParseException;

    protected abstract void sectionEnd(String var1) throws ParseException;
}

