/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFMLine;
import gama.dependencies.kabeja.dxf.helpers.DXFMLineSegment;
import gama.dependencies.kabeja.dxf.helpers.DXFMLineSegmentElement;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFMLineHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_MLINE_STYLENAME = 2;
    public static final int GROUPCODE_MLINE_STYLE_ID = 340;
    public static final int GROUPCODE_MLINE_SCALE_FACTOR = 40;
    public static final int GROUPCODE_MLINE_JUSTIFICATION = 70;
    public static final int GROUPCODE_MLINE_FLAGS = 71;
    public static final int GROUPCODE_MLINE_NUMBER_OF_VERTICES = 72;
    public static final int GROUPCODE_MLINE_NUMBER_OF_LINESTYLEELEMENTS = 73;
    public static final int GROUPCODE_MLINE_VERTEX_X = 11;
    public static final int GROUPCODE_MLINE_VERTEX_Y = 21;
    public static final int GROUPCODE_MLINE_VERTEX_Z = 31;
    public static final int GROUPCODE_MLINE_DIRECTION_X = 12;
    public static final int GROUPCODE_MLINE_DIRECTION_Y = 22;
    public static final int GROUPCODE_MLINE_DIRECTION_Z = 32;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_X = 13;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_Y = 23;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_Z = 33;
    public static final int GROUPCODE_MLINE_ELEMENT_PARAMETER_COUNT = 74;
    public static final int GROUPCODE_MLINE_ELEMENT_PARAMETER = 41;
    public static final int GROUPCODE_MLINE_FILL_PARAMETER_COUNT = 75;
    public static final int GROUPCODE_MLINE_FILL_PARAMETER = 42;
    protected DXFMLine mLine;
    protected DXFMLineSegment seg;
    protected DXFMLineSegmentElement el;
    protected int index = 0;

    @Override
    public String getDXFEntityName() {
        return "MLINE";
    }

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.mLine;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 11: {
                this.seg = new DXFMLineSegment();
                this.mLine.addDXFMLineSegement(this.seg);
                this.seg.getStartPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 21: {
                this.seg.getStartPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 31: {
                this.seg.getStartPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 12: {
                this.seg.getDirection().setX(dXFValue.getDoubleValue());
                break;
            }
            case 22: {
                this.seg.getDirection().setY(dXFValue.getDoubleValue());
                break;
            }
            case 32: {
                this.seg.getDirection().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 13: {
                this.seg.getMiterDirection().setX(dXFValue.getDoubleValue());
                break;
            }
            case 23: {
                this.seg.getMiterDirection().setY(dXFValue.getDoubleValue());
                break;
            }
            case 33: {
                this.seg.getMiterDirection().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.el.setLengthParameter(this.index, dXFValue.getDoubleValue());
                ++this.index;
                break;
            }
            case 74: {
                this.el = new DXFMLineSegmentElement();
                this.seg.addDXFMLineSegmentElement(this.el);
                this.el.setLengthParameters(new double[dXFValue.getIntegerValue()]);
                this.index = 0;
                break;
            }
            case 42: {
                this.el.setFillParameter(this.index, dXFValue.getDoubleValue());
                ++this.index;
                break;
            }
            case 75: {
                this.el.setFillParameters(new double[dXFValue.getIntegerValue()]);
                this.index = 0;
                break;
            }
            case 10: {
                this.mLine.getStartPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.mLine.getStartPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.mLine.getStartPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 71: {
                this.mLine.setFlags(dXFValue.getIntegerValue());
                break;
            }
            case 70: {
                this.mLine.setJustification(dXFValue.getIntegerValue());
                break;
            }
            case 73: {
                this.mLine.setLineCount(dXFValue.getIntegerValue());
                break;
            }
            case 40: {
                this.mLine.setScale(dXFValue.getDoubleValue());
                break;
            }
            case 2: {
                this.mLine.setMLineStyleName(dXFValue.getValue());
                break;
            }
            case 340: {
                this.mLine.setMLineStyleID(dXFValue.getValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.mLine);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.mLine = new DXFMLine();
    }
}

