/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityType;
import gama.dependencies.osmosis.FixedPrecisionCoordinateConvertor;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Tag;
import java.util.Collection;

public class Node
extends Entity
implements Comparable<Node> {
    private double latitude;
    private double longitude;

    public Node(CommonEntityData commonEntityData, double d, double d2) {
        super(commonEntityData);
        this.init(d, d2);
    }

    private Node(Node node) {
        super(node);
        this.init(node.latitude, node.longitude);
    }

    private void init(double d, double d2) {
        this.latitude = d;
        this.longitude = d2;
    }

    public Node(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        super(storeReader, storeClassRegister);
        this.latitude = FixedPrecisionCoordinateConvertor.convertToDouble(storeReader.readInteger());
        this.longitude = FixedPrecisionCoordinateConvertor.convertToDouble(storeReader.readInteger());
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        super.store(storeWriter, storeClassRegister);
        storeWriter.writeInteger(FixedPrecisionCoordinateConvertor.convertToFixed(this.latitude));
        storeWriter.writeInteger(FixedPrecisionCoordinateConvertor.convertToFixed(this.longitude));
    }

    @Override
    public EntityType getType() {
        return EntityType.Node;
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            return this.compareTo((Node)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    @Override
    public int compareTo(Node node) {
        int n;
        if (this.getId() < node.getId()) {
            return -1;
        }
        if (this.getId() > node.getId()) {
            return 1;
        }
        if (this.getVersion() < node.getVersion()) {
            return -1;
        }
        if (this.getVersion() > node.getVersion()) {
            return 1;
        }
        if (this.latitude < node.latitude) {
            return -1;
        }
        if (this.latitude > node.latitude) {
            return 1;
        }
        if (this.longitude < node.longitude) {
            return -1;
        }
        if (this.longitude > node.longitude) {
            return 1;
        }
        if (this.getTimestamp() == null && node.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && node.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && node.getTimestamp() != null && (n = this.getTimestamp().compareTo(node.getTimestamp())) != 0) {
            return n;
        }
        return this.compareTags(node.getTags());
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        this.assertWriteable();
        this.latitude = d;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        this.assertWriteable();
        this.longitude = d;
    }

    @Override
    public Node getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Node(this);
        }
        return this;
    }

    public String toString() {
        String string = null;
        Collection<Tag> collection = this.getTags();
        for (Tag tag : collection) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("name")) continue;
            string = tag.getValue();
            break;
        }
        if (string != null) {
            return "Node(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", name='" + string + "')";
        }
        return "Node(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

