/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.CommonEntityData;
import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.EntityElementProcessor;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Relation;
import gama.dependencies.osmosis.RelationContainer;
import gama.dependencies.osmosis.RelationMember;
import gama.dependencies.osmosis.RelationMemberElementProcessor;
import gama.dependencies.osmosis.RelationMemberListener;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.TagElementProcessor;
import gama.dependencies.osmosis.TagListener;
import gama.dependencies.osmosis.TimestampContainer;
import org.xml.sax.Attributes;

public class RelationElementProcessor
extends EntityElementProcessor
implements TagListener,
RelationMemberListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_MEMBER = "member";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private final TagElementProcessor tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    private final RelationMemberElementProcessor relationMemberElementProcessor = new RelationMemberElementProcessor((BaseElementProcessor)this, this);
    private Relation relation;

    public RelationElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl) {
        super(baseElementProcessor, sink, bl);
    }

    @Override
    public void begin(Attributes attributes) {
        long l = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String string = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (string == null) {
            throw new OsmosisRuntimeException("Relation " + l + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int n = Integer.parseInt(string);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String string2 = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String string3 = attributes.getValue(ATTRIBUTE_NAME_USER);
        long l2 = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        OsmUser osmUser = this.buildUser(string2, string3);
        this.relation = new Relation(new CommonEntityData(l, n, timestampContainer, osmUser, l2));
    }

    @Override
    public ElementProcessor getChild(String string, String string2, String string3) {
        if (ELEMENT_NAME_MEMBER.equals(string3)) {
            return this.relationMemberElementProcessor;
        }
        if (ELEMENT_NAME_TAG.equals(string3)) {
            return this.tagElementProcessor;
        }
        return super.getChild(string, string2, string3);
    }

    @Override
    public void end() {
        this.getSink().process(new RelationContainer(this.relation));
    }

    @Override
    public void processTag(Tag tag) {
        this.relation.getTags().add(tag);
    }

    @Override
    public void processRelationMember(RelationMember relationMember) {
        this.relation.getMembers().add(relationMember);
    }
}

