/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFBlock;
import gama.dependencies.kabeja.dxf.DXFDimensionStyle;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFHatchPattern;
import gama.dependencies.kabeja.dxf.DXFHeader;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.dxf.DXFLineType;
import gama.dependencies.kabeja.dxf.DXFStyle;
import gama.dependencies.kabeja.dxf.DXFView;
import gama.dependencies.kabeja.dxf.DXFViewport;
import gama.dependencies.kabeja.dxf.objects.DXFDictionary;
import gama.dependencies.kabeja.dxf.objects.DXFObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class DXFDocument {
    public static String PROPERTY_ENCODING = "encoding";
    public static final double DEFAULT_MARGIN = 5.0;
    private final Hashtable<String, DXFLayer> layers = new Hashtable();
    private final Hashtable<String, DXFBlock> blocks = new Hashtable();
    private final HashMap<String, DXFLineType> lineTypes = new HashMap();
    private final HashMap<String, DXFDimensionStyle> dimensionStyles = new HashMap();
    private final HashMap<String, DXFStyle> textStyles = new HashMap();
    private final Hashtable<String, String> properties = new Hashtable();
    private final List<DXFViewport> viewports = new ArrayList<DXFViewport>();
    private Bounds bounds = new Bounds();
    private DXFHeader header = new DXFHeader();
    private final HashMap<String, Object> objects = new HashMap();
    private final HashMap<String, DXFHatchPattern> patterns = new HashMap();
    private final List<DXFView> views = new ArrayList<DXFView>();
    private DXFDictionary rootDictionary = new DXFDictionary();

    public DXFDocument() {
        DXFLayer dXFLayer = new DXFLayer();
        dXFLayer.setDXFDocument(this);
        dXFLayer.setName("0");
        this.layers.put("0", dXFLayer);
        this.rootDictionary = new DXFDictionary();
        this.rootDictionary.setDXFDocument(this);
    }

    public void addDXFLayer(DXFLayer dXFLayer) {
        dXFLayer.setDXFDocument(this);
        this.layers.put(dXFLayer.getName(), dXFLayer);
    }

    public DXFLayer getDXFLayer(String string) {
        if (this.layers.containsKey(string)) {
            return this.layers.get(string);
        }
        if (this.layers.containsKey("0")) {
            return this.layers.get("0");
        }
        DXFLayer dXFLayer = new DXFLayer();
        dXFLayer.setName("0");
        this.addDXFLayer(dXFLayer);
        return dXFLayer;
    }

    public boolean containsDXFLayer(String string) {
        return this.layers.containsKey(string);
    }

    public Iterator getDXFLayerIterator() {
        return this.layers.values().iterator();
    }

    public void addDXFLineType(DXFLineType dXFLineType) {
        this.lineTypes.put(dXFLineType.getName(), dXFLineType);
    }

    public DXFLineType getDXFLineType(String string) {
        return this.lineTypes.get(string);
    }

    public Iterator getDXFLineTypeIterator() {
        return this.lineTypes.values().iterator();
    }

    public void addDXFEntity(DXFEntity dXFEntity) {
        dXFEntity.setDXFDocument(this);
        DXFLayer dXFLayer = this.getDXFLayer(dXFEntity.getLayerName());
        dXFLayer.addDXFEntity(dXFEntity);
    }

    public void addDXFBlock(DXFBlock dXFBlock) {
        dXFBlock.setDXFDocument(this);
        this.blocks.put(dXFBlock.getName(), dXFBlock);
    }

    public DXFBlock getDXFBlock(String string) {
        return this.blocks.get(string);
    }

    public Iterator getDXFBlockIterator() {
        return this.blocks.values().iterator();
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        if (this.properties.contains(string)) {
            return this.properties.get(string);
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public Bounds getBounds() {
        this.bounds = new Bounds();
        Enumeration<DXFLayer> enumeration = this.layers.elements();
        while (enumeration.hasMoreElements()) {
            Bounds bounds;
            DXFLayer dXFLayer = enumeration.nextElement();
            if (dXFLayer.isFrozen() || !(bounds = dXFLayer.getBounds()).isValid()) continue;
            this.bounds.addToBounds(bounds);
        }
        return this.bounds;
    }

    public Bounds getBounds(boolean bl) {
        Bounds bounds = new Bounds();
        Enumeration<DXFLayer> enumeration = this.layers.elements();
        while (enumeration.hasMoreElements()) {
            Bounds bounds2;
            DXFLayer dXFLayer = enumeration.nextElement();
            if (dXFLayer.isFrozen() || !(bounds2 = dXFLayer.getBounds(bl)).isValid()) continue;
            bounds.addToBounds(bounds2);
        }
        return bounds;
    }

    public DXFHeader getDXFHeader() {
        return this.header;
    }

    public void setDXFHeader(DXFHeader dXFHeader) {
        this.header = dXFHeader;
    }

    public void addDXFDimensionStyle(DXFDimensionStyle dXFDimensionStyle) {
        this.dimensionStyles.put(dXFDimensionStyle.getName(), dXFDimensionStyle);
    }

    public DXFDimensionStyle getDXFDimensionStyle(String string) {
        return this.dimensionStyles.get(string);
    }

    public Iterator getDXFDimensionStyleIterator() {
        return this.dimensionStyles.values().iterator();
    }

    public void addDXStyle(DXFStyle dXFStyle) {
        this.textStyles.put(dXFStyle.getName(), dXFStyle);
    }

    public DXFStyle getDXFStyle(String string) {
        return this.textStyles.get(string);
    }

    public Iterator getDXFStyleIterator() {
        return this.textStyles.values().iterator();
    }

    public void removeDXFLayer(String string) {
        this.layers.remove(string);
    }

    public void addDXFViewport(DXFViewport dXFViewport) {
        this.viewports.add(dXFViewport);
    }

    public Iterator getDXFViewportIterator() {
        return this.viewports.iterator();
    }

    public void removeDXFViewport(DXFViewport dXFViewport) {
        this.viewports.remove(dXFViewport);
    }

    public void removeDXFViewport(int n) {
        this.viewports.remove(n);
    }

    public void addDXFView(DXFView dXFView) {
        this.views.add(dXFView);
    }

    public Iterator getDXFViewIterator() {
        return this.views.iterator();
    }

    public void addDXFObject(DXFObject dXFObject) {
        DXFDictionary dXFDictionary = this.rootDictionary.getDXFDictionaryForID(dXFObject.getID());
        if (dXFDictionary != null) {
            dXFDictionary.putDXFObject(dXFObject);
        } else {
            HashMap hashMap = null;
            if (this.objects.containsKey(dXFObject.getObjectType())) {
                hashMap = (HashMap)this.objects.get(dXFObject.getObjectType());
            } else {
                hashMap = new HashMap();
                this.objects.put(dXFObject.getObjectType(), hashMap);
            }
            hashMap.put(dXFObject.getID(), dXFObject);
        }
    }

    public DXFDictionary getRootDXFDictionary() {
        return this.rootDictionary;
    }

    public void setRootDXFDictionary(DXFDictionary dXFDictionary) {
        this.rootDictionary = dXFDictionary;
    }

    public List getDXFObjectsByType(String string) {
        HashMap hashMap = (HashMap)this.objects.get(string);
        return new ArrayList(hashMap.values());
    }

    public DXFObject getDXFObjectByID(String string) {
        for (HashMap hashMap : this.objects.values()) {
            Object v = hashMap.get(string);
            if (v == null) continue;
            return (DXFObject)v;
        }
        return this.rootDictionary.getDXFObjectByID(string);
    }

    public DXFEntity getDXFEntityByID(String string) {
        Object object;
        DXFEntity dXFEntity = null;
        Iterator iterator = this.getDXFLayerIterator();
        while (iterator.hasNext()) {
            object = (DXFLayer)iterator.next();
            dXFEntity = ((DXFLayer)object).getDXFEntityByID(string);
            if (dXFEntity == null) continue;
            return dXFEntity;
        }
        iterator = this.getDXFBlockIterator();
        while (iterator.hasNext()) {
            object = (DXFBlock)iterator.next();
            dXFEntity = ((DXFBlock)object).getDXFEntityByID(string);
            if (dXFEntity == null) continue;
            return dXFEntity;
        }
        return dXFEntity;
    }

    public void addDXFHatchPattern(DXFHatchPattern dXFHatchPattern) {
        this.patterns.put(dXFHatchPattern.getID(), dXFHatchPattern);
    }

    public Iterator getDXFHatchPatternIterator() {
        return this.patterns.values().iterator();
    }

    public DXFHatchPattern getDXFHatchPattern(String string) {
        return this.patterns.get(string);
    }
}

