/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf;

import gama.dependencies.kabeja.dxf.Bounds;
import gama.dependencies.kabeja.dxf.DXFConstants;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.helpers.Point;
import gama.dependencies.kabeja.dxf.helpers.Vector;
import gama.dependencies.kabeja.math.MathUtils;
import gama.dependencies.kabeja.math.ParametricPlane;

public class DXFEllipse
extends DXFEntity {
    public static final double DEFAULT_END_PARAMETER = Math.PI * 2;
    public static final double DEFAULT_START_PARAMETER = 0.0;
    public static final int INTEGRATION_STEPS = 15;
    private double ratio = 1.0;
    private double startParameter = 0.0;
    private double endParameter = Math.PI * 2;
    private Point center = new Point();
    private Vector majorAxisDirection = new Vector();
    private boolean counterclockwise;

    public DXFEllipse() {
        this.center = new Point();
    }

    @Override
    public Bounds getBounds() {
        double d = this.getRotationAngle();
        Bounds bounds = new Bounds();
        ParametricPlane parametricPlane = new ParametricPlane(this.center, this.getExtrusion().getDirectionX(), this.getExtrusion().getDirectionY(), this.getExtrusion().getNormal());
        if (this.startParameter == 0.0 && this.endParameter == Math.PI * 2 && d == 0.0) {
            double d2 = this.getHalfMajorAxisLength();
            bounds.addToBounds(parametricPlane.getPoint(d2, d2));
            bounds.addToBounds(parametricPlane.getPoint(-d2, -d2));
        } else {
            int n = 40;
            double d3 = (this.endParameter - this.startParameter) / (double)n;
            double d4 = this.startParameter;
            Vector vector = MathUtils.crossProduct(this.getExtrusion().getNormal(), this.getMajorAxisDirection());
            vector = MathUtils.scaleVector(vector, this.ratio);
            int n2 = 0;
            while (n2 <= n) {
                Vector vector2 = MathUtils.scaleVector(this.getMajorAxisDirection(), Math.cos(d4));
                Vector vector3 = MathUtils.scaleVector(vector, Math.sin(d4));
                double d5 = vector2.getX() + vector3.getX();
                double d6 = vector2.getY() + vector3.getY();
                Point point = parametricPlane.getPoint(d5, d6);
                bounds.addToBounds(point);
                d4 += d3;
                ++n2;
            }
        }
        return bounds;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public void setCenterPoint(Point point) {
        this.center = point;
    }

    public Vector getMajorAxisDirection() {
        return this.majorAxisDirection;
    }

    public void setMajorAxisDirection(Vector vector) {
        this.majorAxisDirection = vector;
    }

    public double getEndParameter() {
        return this.endParameter;
    }

    public void setEndParameter(double d) {
        this.endParameter = d < 0.0 ? Math.PI * 2 + d : d;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        this.ratio = d;
    }

    public double getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(double d) {
        this.startParameter = d < 0.0 ? Math.PI * 2 + d : d;
    }

    @Override
    public String getType() {
        return "ELLIPSE";
    }

    public double getHalfMajorAxisLength() {
        return this.majorAxisDirection.getLength();
    }

    public Point getLocalPointAt(double d) {
        Point point = new Point();
        double d2 = this.getHalfMajorAxisLength();
        double d3 = d2 * this.ratio;
        double d4 = d2 * Math.cos(d);
        double d5 = d3 * Math.sin(d);
        double d6 = this.getRotationAngle();
        if (d6 != 0.0) {
            double d7 = d4;
            d4 = d7 * Math.cos(d6) - d5 * Math.sin(d6);
            d5 = d7 * Math.sin(d6) + d5 * Math.cos(d6);
        }
        point.setX(d4);
        point.setY(d5);
        point.setZ(0.0);
        return point;
    }

    public Point getPointAt(double d) {
        ParametricPlane parametricPlane = new ParametricPlane(this.center, this.getExtrusion().getDirectionX(), this.getExtrusion().getDirectionY(), this.getExtrusion().getNormal());
        Vector vector = MathUtils.crossProduct(this.getExtrusion().getNormal(), this.getMajorAxisDirection());
        vector = MathUtils.scaleVector(vector, this.ratio);
        Vector vector2 = MathUtils.scaleVector(this.getMajorAxisDirection(), Math.cos(d));
        Vector vector3 = MathUtils.scaleVector(vector, Math.sin(d));
        double d2 = vector2.getX() + vector3.getX();
        double d3 = vector2.getY() + vector3.getY();
        return parametricPlane.getPoint(d2, d3);
    }

    public Point getLocalStartPoint() {
        return this.getLocalPointAt(this.startParameter);
    }

    public Point getLocalEndPoint() {
        return this.getLocalPointAt(this.endParameter);
    }

    public double getRotationAngle() {
        return MathUtils.getAngle(DXFConstants.DEFAULT_X_AXIS_VECTOR, this.majorAxisDirection);
    }

    @Override
    public double getLength() {
        int n = 15;
        double d = (this.endParameter - this.startParameter) / (double)n;
        double d2 = this.getHalfMajorAxisLength();
        double d3 = d2 * this.ratio;
        double d4 = this.startParameter;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d7 = d / 2.0 + d4;
            d5 = d4 + d;
            double d8 = Math.sqrt(Math.pow(d2 * Math.sin(d4), 2.0) + Math.pow(d3 * Math.cos(d4), 2.0));
            double d9 = Math.sqrt(Math.pow(d2 * Math.sin(d7), 2.0) + Math.pow(d3 * Math.cos(d7), 2.0));
            double d10 = Math.sqrt(Math.pow(d2 * Math.sin(d5), 2.0) + Math.pow(d3 * Math.cos(d5), 2.0));
            d6 += (d8 + 4.0 * d9 + d10) * (d / 6.0);
            d4 = d5;
            ++n2;
        }
        return d6;
    }

    public boolean isCounterClockwise() {
        return this.counterclockwise;
    }

    public void setCounterClockwise(boolean bl) {
        this.counterclockwise = bl;
    }
}

