/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.DummyElementProcessor;
import gama.dependencies.osmosis.ElementProcessor;
import gama.dependencies.osmosis.SimpleTimestampContainer;
import gama.dependencies.osmosis.TimestampContainer;
import gama.dependencies.osmosis.TimestampFormat;
import gama.dependencies.osmosis.UnparsedTimestampContainer;
import gama.dependencies.osmosis.XmlTimestampFormat;
import java.util.Calendar;

public abstract class BaseElementProcessor
implements ElementProcessor {
    private final BaseElementProcessor parentProcessor;
    private ElementProcessor dummyChildProcessor;
    private TimestampFormat timestampFormat;
    private TimestampContainer dummyTimestampContainer;
    private final boolean enableDateParsing;

    protected BaseElementProcessor(BaseElementProcessor baseElementProcessor, boolean bl) {
        this.parentProcessor = baseElementProcessor;
        this.enableDateParsing = bl;
        if (bl) {
            this.timestampFormat = new XmlTimestampFormat();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            this.dummyTimestampContainer = new SimpleTimestampContainer(calendar.getTime());
        }
    }

    @Override
    public ElementProcessor getChild(String string, String string2, String string3) {
        if (this.dummyChildProcessor == null) {
            this.dummyChildProcessor = new DummyElementProcessor(this);
        }
        return this.dummyChildProcessor;
    }

    @Override
    public ElementProcessor getParent() {
        return this.parentProcessor;
    }

    protected TimestampContainer createTimestampContainer(String string) {
        if (this.enableDateParsing) {
            return new UnparsedTimestampContainer(this.timestampFormat, string);
        }
        return this.dummyTimestampContainer;
    }
}

